package com.common.fragment;

import android.os.Bundle;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.WebChromeClient;
import android.webkit.WebSettings;
import android.webkit.WebView;

import com.qmuiteam.qmui.util.QMUIStatusBarHelper;

import tech.starwin.R;
import com.common.base.BaseFragment;
import tech.starwin.utils.context_utils.ActivityJumper;
import com.common.widget.TopBar;

/**
 * Created by SiKang on 2018/11/20.
 */
public class RepaymentH5Fragment extends BaseFragment {

    @Override
    public boolean useTopBar() {
        return true;
    }

    @Override
    protected void initTopBar(TopBar topBar) {
        topBar.setStatusBarHeight(QMUIStatusBarHelper.getStatusbarHeight(getActivity()));
        topBar.toolBar().setBackgroundColor(getResources().getColor(R.color.translateColor));
        topBar.toolBar().addLeftBackImageButton().setVisibility(View.INVISIBLE);
        topBar.toolBar().setTitle(R.string.repayment_text);
    }

    WebView webView;

    public static Bundle createArguments(String repayUrl) {
        return new ActivityJumper.Builder()
                .put("url", repayUrl)
                .toBundle();
    }

    @Override
    public int bindLayout() {
        return R.layout.activity_web;
    }

    @Override
    public void initView(ViewGroup contentView) {
        String url = getArguments().getString("url");

        webView = (WebView) findViewById(R.id.activity_web_wv);

        WebSettings seting = webView.getSettings();
        seting.setJavaScriptEnabled(true);//设置webview支持javascript脚本

        webView.setWebChromeClient(new WebChromeClient() {
            @Override
            public void onProgressChanged(WebView view, int newProgress) {
                if (newProgress == 100) {
                    onHttpFinish("");
                } else {
                    onHttpStart("", true);
                }

            }
        });

        webView.loadUrl(url);
    }

    @Override
    public void onHttpSuccess(String action, Object result) {

    }
}
