package tech.starwin.mvp.ui.adapter;

import android.content.Context;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;

import java.util.List;

import tech.starwin.R;
import tech.starwin.base.BaseRecyclerAdapter;
import tech.starwin.base.RecyclerViewHolder;
import tech.starwin.impl.OnEventClickListener;
import tech.starwin.mvp.beans.LoanAppHelpCenterTipsBean;

/**
 * Created by SiKang on 2018/11/1.
 */
public class HelpCenterAdapter extends BaseRecyclerAdapter<LoanAppHelpCenterTipsBean> {
    public HelpCenterAdapter(Context ctx, List<LoanAppHelpCenterTipsBean> list) {
        super(ctx, list);
    }

    @Override
    public Object bindItemLayout() {
        return R.layout.item_help_center;
    }

    @Override
    public void bindData(RecyclerViewHolder holder, int position, LoanAppHelpCenterTipsBean item) {
        TextView titleTv = holder.getTextView(R.id.item_helpCenter_title_tv);
        TextView detailTv = holder.getTextView(R.id.item_helpCenter_detail_tv);
        ImageView instructionImv = holder.getImageView(R.id.item_helpCenter_instruction_imv);

        titleTv.setText(item.mTitle);
        detailTv.setText(item.mDetail);
        holder.getView(R.id.item_helpCenter_item_view).setOnClickListener(new OnEventClickListener() {
            @Override
            public void onEventClick(View v) {
                if (instructionImv.isSelected()) {
                    instructionImv.setSelected(false);
                    detailTv.setVisibility(View.GONE);
                } else {
                    instructionImv.setSelected(true);
                    detailTv.setVisibility(View.VISIBLE);
                }
            }
        });
    }

}
