package tech.starwin.mvp.api;


import java.util.List;

import io.reactivex.Observable;
import okhttp3.MultipartBody;
import okhttp3.ResponseBody;
import retrofit2.Call;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Multipart;
import retrofit2.http.PUT;
import retrofit2.http.Part;
import retrofit2.http.Query;
import tech.starwin.mvp.beans.BasicAck;
import tech.starwin.mvp.beans.OcrResultBean;
import tech.starwin.mvp.beans.RecordFilesResponse;

public interface UploadApi {
    @Multipart
    @PUT("record/files")
    Call<ResponseBody> uploadPhoto(
            @Part MultipartBody.Part photoFile,
            @Query("fileType") String fileType,
            @Header("X-AUTH-TOKEN") String token
    );


    @Multipart
    @PUT("loanapp/contract/video")
    Call<ResponseBody> uploadVideo(@Part MultipartBody.Part videoFile,
                                   @Query("loanAppId") String loanAppId,
                                   @Query("fileType") String fileType,
                                   @Header("X-AUTH-TOKEN") String token);

    @GET("record/files")
    Observable<RecordFilesResponse> recordFiles(@Header("X-AUTH-TOKEN") String token);

    @Multipart
    @PUT("/loanapp/verify/face")
    Observable<BasicAck> faceVerify(@Query("loanType") String loanType,
                                    @Query("amount") double amount,
                                    @Query("period") int period,
                                    @Query("periodUnit") String periodUnit,
                                    @Part MultipartBody.Part imageBest,
                                    @Part MultipartBody.Part imageEnv,
                                    @Part MultipartBody.Part delta,
                                    @Query("imei") String imei,
                                    @Header("X-AUTH-TOKEN") String token);

    /**
     * 身份证ocr识别
     * */
    @Multipart
    @PUT("/record/ocr")
    Call<OcrResultBean> identityOcr(@Part List<MultipartBody.Part> parts, @Header("X-AUTH-TOKEN") String token);
}