# -*-coding:utf-8-*-
import random
import re
import os

class JavaGarble:
    __used_names = []
    __variables = []
    __functions = []

    def __gen_rand_str(self):
        result = ""
        while len(result) == 0 or result in self.__used_names:
            result = ''.join(random.sample(
                "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ", random.randint(1, 2)))
        self.__used_names.append(result)
        return result


    # 生成变量
    def __generate_variable(self):
        var_scope = ["public", "private", "protected"]
        var_types = ["String", "int", "double", "float"]
        var_count = random.randint(random.randint(3,10), random.randint(20,30))
        for i in range(0, var_count):
            code = "%s %s %s = " % (
                var_scope[random.randint(0, 2)],
                var_types[random.randint(0, 3)],
                self.__gen_rand_str()
            )
            if " String " in code:
                code += "\"%s\"" % self.__gen_rand_str()
            else:
                code += "%d" % random.randint(1, 1000)
            code += ";"
            self.__variables.append(code)

    # 生成方法
    def __generate_function(self, model_path):
        func_scope = ["public", "private", "protected"]
        return_type = ["String", "int", "double", "float"]

        fun_content = ""
        with open(model_path, "r", encoding="utf-8") as fin:
            fun_content = fin.read()

        re_type = return_type[random.randint(0, 3)]
        fun_content = fun_content\
            .replace("${func_scope}", func_scope[random.randint(0, 2)])\
            .replace("${return_type}", re_type)\
            .replace("${func_name}", self.__gen_rand_str())

        # 方法参数
        param_names = []
        params_code = ""
        for i in range(0, random.randint(1, 5)):
            parans_name = self.__gen_rand_str()
            code = "%s %s" % (
                return_type[random.randint(0, 3)],
                parans_name
            )
            params_code += code + ", "
            param_names.append(parans_name)

        params_code = ("%s*" % params_code).replace(", *", "")
        fun_content = fun_content.replace("${params}", params_code)

        # 随机引用全局变量
        for var_code in self.__variables:
            if random.randint(0, 2) % 2 == 0:
                param_names.append(var_code.split(" ")[2])
        return_value = ""
        for name in param_names:
            return_value += name + "+"

        # 转string
        return_value += "\"\""

        if re_type in "int":
            return_value = "(%s).length()" % return_value
        elif re_type in "float":
            return_value = "Float.valueOf((%s).length())" % return_value
        elif re_type in "double":
            return_value = "Double.valueOf((%s).length())" % return_value

        return_value = "return %s;" % return_value

        log_code = ""
        for i in range(0, random.randint(0, 5)):
            log_code += "Log.%s(\"%s\",\"%s\");\n" % (
                ''.join(random.sample("idew", random.randint(1, 1))),
                self.__name,
                ''.join(random.sample("ABCDEFGHIJKLMNOPQRSTUVWXYZ", random.randint(5, 15)))
            )

        fun_content = fun_content.replace(
            "${func_content}", log_code + return_value)
        self.__functions.append(fun_content)

        if len(self.__functions) < random.randint(3, 10):
            self.__generate_function(model_path)

    #插入代码
    def __garble_java_file(self,file):
        with open(file,"r",encoding="utf-8") as fin:
            lines = fin.readlines()
        
        #生成全局变量
        self.__generate_variable()
        #生成方法
        self.__generate_variable()
        ignore = False
        with open(file,"w+",encoding="utf-8") as fout:
            for line in lines:
                # interface 不混淆
                if "interface" in line and "{\n" in line:
                   ignore = True 
                
                if ignore:
                    fout.write(line)
                    continue

                #class下插入全局变量
                if (line.startswith("class ") or " class " in line) and "{\n" in line:
                    for var in self.__variables:
                        line +="%s\n"% var
                    for fun in self.__functions:
                        line +="%s\n"% fun
                
                #只有一个缩进的方法，为类方法，可插入同级方法
                # func_re = re.compile(r'\s{4}[a-zA-Z](.*)[)]\s{0,}[{]')
                # result = func_re.match(line)
                # if result != None:
                #     print(result.group())
                # if :
            fout.write(line)
                
    def java_garble(self,config):
        __used_names = []
        __variables = []
        __functions = []
        for main_dir in config['lib_main']:
            for root, dirs, files in os.walk("%s/%s"%(config["root"],main_dir)):
                for file in files:
                    if file.endswith(".java"):
                        self.__garble_java_file(os.path.join(root,file))
