package com.common.activity;

import android.content.Intent;
import android.support.annotation.DrawableRes;
import android.support.v4.app.FragmentActivity;
import android.text.TextUtils;
import android.view.View;
import android.widget.Button;
import android.widget.ImageView;


import com.qmuiteam.qmui.util.QMUIStatusBarHelper;

import java.io.File;

import tech.starwin.R;
import com.common.base.BaseActivity;

import tech.starwin.impl.OnNoShakeClickListener;
import tech.starwin.utils.BitmapUtils;
import tech.starwin.utils.FileUtils;
import tech.starwin.utils.context_utils.ActivityJumper;
import tech.starwin.utils.context_utils.EasyActivityResult;
import tech.starwin.utils.ui_utils.QMUIHelper;
import tech.starwin.utils.ui_utils.UIHelper;
import com.common.widget.CameraView;
import com.common.widget.TopBar;

/**
 * Created by SiKang on 2018/9/25.
 */
public class TakePhotoActivity extends BaseActivity {
    public enum PhotoType {
        KTP,
        WORK_CARD
    }

    public static void startForResult(FragmentActivity activity, int requestCode, PhotoType type, @DrawableRes int previewMask, @DrawableRes int shootBtnImg, EasyActivityResult.OnResultListener result) {
        Intent intent = new ActivityJumper.Builder(activity, TakePhotoActivity.class)
                .put("photo_type", type.name())
                .put("preview_mask", previewMask)
                .put("shoot_btn_img", shootBtnImg)
                .toIntent();
        new EasyActivityResult(activity).startForResult(intent, requestCode, result);
    }


    ImageView btnCapture;
    ImageView maskImv;
    Button mbtnCancel;
    CameraView cameraView;

    public static String KTP_IMAGE = "ktp_img.jpg";

    @Override
    public boolean useTopBar() {
        return false;
    }

    @Override
    public int bindLayout() {
        return R.layout.activity_take_photo;
    }


    @Override
    public void initView() {
        QMUIStatusBarHelper.translucent(this);

        TopBar topBar = findViewById(R.id.activity_take_photo_topbar);
        topBar.setStatusBarHeight(QMUIStatusBarHelper.getStatusbarHeight(this));
        topBar.toolBar().addLeftBackImageButton().setOnClickListener(v -> finish());
        QMUIHelper.getTopbarCustomizer().madeTopBar(topBar);

        btnCapture = findViewById(R.id.button_shoot);
        mbtnCancel = findViewById(R.id.button_cancel);
        cameraView = findViewById(R.id.cameraView);
        maskImv = findViewById(R.id.activity_takephoto_mask_imv);

        cameraView.setTargetPreviewSize(1280, 720);

        int mask = getIntent().getIntExtra("preview_mask", 0);
        int btnImg = getIntent().getIntExtra("shoot_btn_img", 0);
        if (mask != 0) {
            maskImv.setImageResource(mask);
        }
        if (btnImg != 0) {
            btnCapture.setImageResource(btnImg);
        }
        String type = getIntent().getStringExtra("photo_type");
        if (TextUtils.equals(type, PhotoType.KTP.name())) {
            findViewById(R.id.imageview_id_frame).setVisibility(View.VISIBLE);
        }

        UIHelper.bindClickListener(new OnNoShakeClickListener() {
            @Override
            public void onEventClick(View v) {
                if (v.getId() == R.id.button_shoot) {
                    cameraView.captureImage(bitmap -> {
                        File image = FileUtils.getImageFile(getApplicationContext(), KTP_IMAGE);
                        if (!image.exists()) {
                            image.mkdir();
                        }

                        File file = BitmapUtils.saveBitmapToSDCard(bitmap, image, 100);
                        if(file==null){
                            setResult(RESULT_CANCELED);
                            finish();
                            return;
                        }
                        //如果图片过大，则压缩
                        long size=FileUtils.getFileSize(file)/1024;
                        if (FileUtils.getFileSize(file) / 1024 > 1024) {
                            int quality = (int) (100 * (1024f / size));
                            file = BitmapUtils.saveBitmapToSDCard(bitmap, image, quality);

                        }

                        Intent intent = new Intent();
                        intent.putExtra("image_path", image.getAbsolutePath());
                        setResult(RESULT_OK, intent);
                        finish();

//                        try {
//                            FileOutputStream outputStream = new FileOutputStream(image.getPath());
//                            outputStream.write(data);
//                            outputStream.close();
//
//                        } catch (java.io.IOException e) {
//                            e.printStackTrace();
//                        }
                    });
                } else if (v.getId() == R.id.button_cancel) {
                    setResult(RESULT_CANCELED);
                    finish();
                }
            }
        }, mbtnCancel, btnCapture);

    }


    @Override
    protected void onResume() {
        cameraView.startPreview();
        super.onResume();
    }

    @Override
    protected void onStop() {
        cameraView.stopPreview();
        super.onStop();
    }

    @Override
    protected void onDestroy() {
        cameraView.release();
        super.onDestroy();
    }

    @Override
    public void onHttpSuccess(String action, Object result) {

    }
}
