#!/usr/bin/env python3
import json
import string
import random
import glob, os
import sys


def getResValue(line):
    return line.split(",")[2].replace("\\\"","").replace("'","").replace(" ","").replace(")","").replace("'\n","")

def addToProperties(line):
    os.system("./update_properties.py "+line)

def getStringFiled(key,value):
    return "\t\t\tbuildConfigField 'String', '" + key + "', " + value + "\n"

def getColorRes(key,value):
    return "\t\t\tresValue('color', '"+key+"', " + value + ")\n"

def getStringRes(key,value):
    return "\t\t\tresValue('string', '"+key+"', " + value + ")\n"

def move_config(path):
    # print("processing content: %s..." % path)
    with open(path, "r", encoding="utf-8") as f:
        # readlines以列表的形式将文件读出
        lines = f.readlines()
    move_finished=0
    with open(path, "w", encoding="utf-8") as f_w:
        for line in lines:
            if "product {" in line:
                move_finished += 1
            if move_finished == 1 and "{" in line:
                move_finished +=1
            if move_finished >1:
                break


            if "app_name_str" in line:
                addToProperties("app_name="+getResValue(line))
                line = getStringRes("app_name_str","\"${app_name}\"")
                
            if "LANGUAGE" in line:
                if line.startswith("//"):
                    line = ""
                else:
                    addToProperties("language=in")
                    line = getStringFiled("LANGUAGE","\"${language}\"")

            if "'color', 'main_color'" in line:
                addToProperties("main_color="+getResValue(line))
                line = getColorRes("main_color","\"${main_color}\"")

            if "'color', 'main_text_color'" in line:
                addToProperties("main_text_color="+getResValue(line))
                line = getColorRes("main_text_color","\"${main_text_color}\"")

            f_w.write(line)
    return


move_config("../../../app/app_config.gradle")