package tech.starwin.impl;

import android.view.View;

/**
 * Created by SiKang on 2018/9/18.
 */
public abstract class OnNoShakeClickListener extends OnEventClickListener {

    public int lockTime = 1500;

    public OnNoShakeClickListener(int milliSencons) {
        this.lockTime = milliSencons;
    }

    public OnNoShakeClickListener() {
    }

    @Override
    public void onClick(final View v) {
        super.onClick(v);
        v.setClickable(false);
        v.postDelayed(new Runnable() {
            @Override
            public void run() {
                v.setClickable(true);
            }
        }, lockTime);
        onEventClick(v);
    }

    @Override
    public void onEventClick(View v) {

    }
}
