package tech.starwin.mvp.api;

import java.util.List;

import io.reactivex.Observable;
import okhttp3.ResponseBody;
import retrofit2.http.Field;
import retrofit2.http.FormUrlEncoded;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.POST;
import retrofit2.http.Query;
import tech.starwin.mvp.beans.DepositMethodsBean;
import tech.starwin.mvp.beans.DepositResponseBean;
import tech.starwin.mvp.beans.HistoryLoanAppInfoBean;
import tech.starwin.mvp.beans.LatestLoanAppBean;
import tech.starwin.mvp.beans.LoanRange;
import tech.starwin.mvp.beans.ProgressBean;
import tech.starwin.mvp.beans.ResponseErrorBody;

/**
 * Created by SiKang on 2018/9/20.
 */
public interface LoanApi {
    /**
     * 获取贷款额度、期限 范围
     */
    @GET("loanapp/range")
    Observable<LoanRange> getLoanRange();

    /**
     * 验证贷款资格
     */
    @GET("loanapp/qualification")
    Observable<ResponseErrorBody> isQualification(@Header("X-AUTH-TOKEN") String token);

    /**
     * 贷款进度
     */
    @GET("record/progress")
    Observable<ProgressBean> getLoanProgress(@Header("X-AUTH-TOKEN") String token);


    /**
     * 获取最新的贷款申请信息
     */
    @GET("loanapp/latest/v2")
    Observable<LatestLoanAppBean> getLatestLoanApp(@Header("X-AUTH-TOKEN") String token);


    /**
     * 取消贷款
     */
    @FormUrlEncoded
    @POST("loanapp/cancel")
    Observable<ResponseBody> cancelLoan(@Field("loanAppId") String loanAppId,
                                        @Header("X-AUTH-TOKEN") String token);

    /**
     * 我的贷款记录
     */
    @GET("loanapp/all/v2")
    Observable<List<HistoryLoanAppInfoBean>> getLoanAppAll(@Header("X-AUTH-TOKEN") String token);


    /**
     * 获取付款方式
     */
    @GET("loanapp/deposit/methods")
    Observable<DepositMethodsBean> getDepostMethods(@Header("X-AUTH-TOKEN") String token);


    /**
     * 还款
     *
     * @param loanAppId 贷款订单id
     * @param method    还款方式
     * @param amout     还款金额
     */
    @POST("loanapp/deposit")
    Observable<DepositResponseBean> doDeposit(@Query("loanAppId") String loanAppId,
                                              @Query("currency") String currency,
                                              @Query("depositMethod") String method,
                                              @Query("amount") double amout,
                                              @Header("X-AUTH-TOKEN") String token
    );


}
