package tech.starwin.mvp.presenter;


import tech.starwin.base.BasePresenter;
import tech.starwin.mvp.api.LoanApi;
import tech.starwin.utils.LoginManager;

/**
 * Created by SiKang on 2018/9/20.
 */
public class LoanPresenter extends BasePresenter<LoanApi> {
    public LoanPresenter() {
        super(LoanApi.class);
    }

    /**
     * 获取贷款额度、贷款周期 可选范围
     */
    public void getLoanRange(String action) {
        handleRequest(action, apiService.getLoanRange());
    }

    /**
     * 验证贷款资格
     */
    public void checkQualification(String action) {
        handleRequest(action, apiService.isQualification(LoginManager.get().getToken()));
    }

    /**
     * 获取贷款进度
     */
    public void getLoanProgress(String action) {
        handleRequest(action, apiService.getLoanProgress(LoginManager.get().getToken()));
    }


    /**
     * 获取最新的贷款申请信息
     */
    public void getLatestLoanApp(String action) {
        handleRequest(action, apiService.getLatestLoanApp(LoginManager.get().getToken()));
    }

    /**
     * 获取贷款记录
     */
    public void getLoanHistory(String action) {
        handleRequest(action, apiService.getLoanAppAll(LoginManager.get().getToken()));
    }


    /**
     * 取消贷款
     * */
    public void cancelLoan(String action,String loanAppId){
        handleRequest(action,apiService.cancelLoan(loanAppId,LoginManager.get().getToken()));
    }


}
