package tech.starwin.mvp.presenter;

import android.annotation.SuppressLint;
import android.support.annotation.NonNull;

import com.google.gson.Gson;


import java.io.File;

import okhttp3.ResponseBody;
import tech.starwin.base.BasePresenter;
import tech.starwin.impl.HttpObserver;
import tech.starwin.mvp.api.UploadApi;
import tech.starwin.mvp.beans.EmploymentBean;
import tech.starwin.mvp.beans.OcrResultBean;
import tech.starwin.utils.LoginManager;
import tech.starwin.utils.MultipartBodyMaker;

/**
 * Created by SiKang on 2018/9/25.
 */
public class UploadPresenter extends BasePresenter<UploadApi> {

    public UploadPresenter() {
        super(UploadApi.class);
    }

    /**
     * 身份证ocr识别
     */
    public void identityOcr(final String action, @NonNull File file) {
        handleRequest(apiService.identityOcr(MultipartBodyMaker.makeSimplePart("file", file), LoginManager.get().getToken()), new HttpObserver<OcrResultBean>() {
            @Override
            public void onStart() {
                view.onHttpStart(action, true);
            }

            @Override
            public void onSuccess(OcrResultBean data) {
                OcrResultBean.KTP ktp = new Gson().fromJson(data.getData(), OcrResultBean.KTP.class);
                if (ktp.getResult().equals("PASS"))
                    view.onHttpSuccess(action, ktp);
                else
                    view.onHttpError(action, ktp.getMessage());
            }

            @Override
            public void onError(int code, String msg) {
                view.onHttpError(action, msg);
            }

            @Override
            public void onFinish() {
                view.onHttpFinish(action);
            }
        });
    }

    /**
     * 上传工作证件照片
     */
    @SuppressLint("CheckResult")
    public void uploadEmploymentImg(final String action, EmploymentBean employmentBean, @NonNull File file) {
        handleRequest(apiService.uploadPhoto(MultipartBodyMaker.makeSimplePart("file", file), "EMPLOYMENT_PHOTO", LoginManager.get().getToken()),
                new HttpObserver<ResponseBody>() {
                    @Override
                    public void onStart() {
                        view.onHttpStart(action, true);
                    }

                    @Override
                    public void onSuccess(ResponseBody responseBody) {
                        view.onHttpSuccess(action, responseBody);
                    }

                    @Override
                    public void onError(int code, String msg) {
                        view.onHttpError(action, msg);
                    }

                    @Override
                    public void onFinish() {
                        view.onHttpFinish(action);
                    }
                });
    }
}
