package tech.starwin.network;

import java.util.Arrays;
import java.util.List;

import tech.starwin.BuildConfig;
import tech.starwin.base.LibConfig;
import tech.starwin.mvp.beans.GatewayInfoBean;
import tech.starwin.utils.PreferencesManager;

/**
 * Created by SiKang on 2018/9/28.
 */
public class Gateway {
    private static GatewayInfoBean gatewayInfo;

    static {
        gatewayInfo = PreferencesManager.get().getGatewayInfo();
        if (gatewayInfo == null) {
            gatewayInfo = new GatewayInfoBean();
            gatewayInfo.gateway = Arrays.asList(LibConfig.GATEWAY_HOST_G0,
                    LibConfig.GATEWAY_HOST_G1);
            gatewayInfo.rest = Arrays.asList(LibConfig.API_BASE_URL);
            gatewayInfo.privacy = Arrays.asList(LibConfig.AGREEMENT_URL);
            gatewayInfo.admin = Arrays.asList(LibConfig.ADMIN_HOST);
            gatewayInfo.harvester = Arrays.asList(LibConfig.HARVESTER_IP + ":" + LibConfig.HARVESTER_PORT);
        }
    }

    /**
     * 更新gateway
     */
    public static void notify(GatewayInfoBean info) {
        gatewayInfo.notifyWith(info);
    }

    public static List<String> getGatewayUrl() {
        return gatewayInfo.gateway;
    }

    public static String getPrivacyUrl() {
        return gatewayInfo.privacy.get(0);
    }

    public static String getHarvesterUrl() {
        return gatewayInfo.harvester.get(0);
    }

    public static String getAdminUrl() {
        return gatewayInfo.admin.get(0);
    }

    public static String getRestUrl() {
        return gatewayInfo.rest.get(0);
    }

}
