package tech.starwin;

import android.app.Application;
import android.content.Context;
import android.view.View;

import com.google.firebase.remoteconfig.FirebaseRemoteConfig;
import com.google.firebase.remoteconfig.FirebaseRemoteConfigSettings;
import com.scwang.smartrefresh.layout.SmartRefreshLayout;
import com.scwang.smartrefresh.layout.api.DefaultRefreshFooterCreator;
import com.scwang.smartrefresh.layout.api.DefaultRefreshHeaderCreator;
import com.scwang.smartrefresh.layout.api.RefreshFooter;
import com.scwang.smartrefresh.layout.api.RefreshHeader;
import com.scwang.smartrefresh.layout.api.RefreshLayout;
import com.scwang.smartrefresh.layout.footer.ClassicsFooter;
import com.scwang.smartrefresh.layout.header.ClassicsHeader;
import com.tencent.bugly.crashreport.CrashReport;

import cn.fraudmetrix.octopus.aspirit.main.OctopusManager;
import tech.starwin.network.Gateway;
import tech.starwin.utils.FireBaseHelper;
import tech.starwin.utils.PreferencesManager;
import tech.starwin.utils.collection.UploadManager;
import zendesk.core.AnonymousIdentity;
import zendesk.core.Zendesk;
import zendesk.support.Support;

import static com.facebook.accountkit.internal.AccountKitController.getApplicationContext;

/**
 * Created by SiKang on 2018/9/30.
 * 配置 BaseLibrary
 */
public class LibConfig {

    /**
     * 存储 App Module的 BuildConfig 数据
     */
    private static Context CONTEXT;
    public static boolean DEBUG;
    public static String APPLICATION_ID;
    public static String BUILD_TYPE;
    public static String FLAVOR;
    public static int VERSION_CODE;
    public static String VERSION_NAME;
    public static String FLAVOR_default;
    public static String FLAVOR_server;
    public static String AGREEMENT_URL;
    public static String APP_URL;
    public static String BUGLY_APP_ID;
    public static String CONTRACT_URL;
    public static String HOTLINE;
    public static String LOAN_AGREEMENT;
    public static String LOGIN_ACTIVITY_ACTION;
    public static String ROOT_DIR;
    public static String ADMIN_HOST;
    public static String API_BASE_URL;
    public static String GATEWAY_HOST_G0;
    public static String GATEWAY_HOST_G1;
    public static String HARVESTER_IP;
    public static String ZENDESK_URL;
    public static String ZENDESK_APP_ID;
    public static String ZENDESK_OAUTH_CLIENT_ID;
    public static String TONGDUN_PARENT_CODE;
    public static String TONGDUN_PARENT_KEY;
    public static String LANGUAGE = "en";
    public static int HARVESTER_PORT;//
    public static int LOADING_ICON;//loading图标
    public static int LOADING_BACKGROUND;//loading旋转背景
    public static int MAIN_COLOR;//主题色

    public static ButterKnifeBinder butterKnifeBinder;

    public static Context getContext() {
        if (CONTEXT == null)
            throw new RuntimeException("context is null ! you must execute LibConfig.initLib(context) in your Appliaction");
        return CONTEXT;
    }


    /**
     * 初始化 BaseLibrary
     */
    public static void initLib(Application application) {
        if (application != null) {
            CONTEXT = application;

//            if (!TextUtils.isEmpty(LANGUAGE)) {
//                loadAppLanguage(application, LANGUAGE);
//            }

            //上传工具
            UploadManager.init(CONTEXT);

            //init FireBase RemoteConfig
            //RemoteConfig
            FirebaseRemoteConfig.getInstance().setConfigSettings(
                    new FirebaseRemoteConfigSettings.Builder()
                            .setDeveloperModeEnabled(LibConfig.DEBUG)
                            .build()
            );
            FireBaseHelper.fetchRemoteConfig();

            //init SharePreferences
            PreferencesManager.get().init(application);

            //init gateway
            Gateway.init(PreferencesManager.get().getGatewayInfo());

            //init Bugly
            CrashReport.initCrashReport(getApplicationContext(), BUGLY_APP_ID, DEBUG);

            //init zendesk
            Zendesk.INSTANCE.init(application, ZENDESK_URL, ZENDESK_APP_ID, ZENDESK_OAUTH_CLIENT_ID);
            Support.INSTANCE.init(Zendesk.INSTANCE);
            Zendesk.INSTANCE.setIdentity(new AnonymousIdentity());//匿名身份

            //同盾
            OctopusManager.getInstance().init(CONTEXT, TONGDUN_PARENT_CODE, TONGDUN_PARENT_KEY);
            OctopusManager.getInstance().setPrimaryColorResId(MAIN_COLOR);
            OctopusManager.getInstance().setTitleColorResId(R.color.white);
            OctopusManager.getInstance().setShowWarnDialog(true);
            OctopusManager.getInstance().setStatusBarBg(MAIN_COLOR);
//            FirebaseDynamicLinks.getInstance()
//                    .getDynamicLink(getIntent())
//                    .addOnSuccessListener(this, new OnSuccessListener<PendingDynamicLinkData>() {
//                        @Override
//                        public void onSuccess(PendingDynamicLinkData pendingDynamicLinkData) {
//                            // Get deep link from result (may be null if no link is found)
//                            Uri deepLink = null;
//                            if (pendingDynamicLinkData != null) {
//                                deepLink = pendingDynamicLinkData.getLink();
//                            }
//
//                            // Handle the deep link. For example, open the linked
//                            // content, or apply promotional credit to the user's
//                            // account.
//                            // ...
//
//                            // ...
//                        }
//                    })
//                    .addOnFailureListener(this, new OnFailureListener() {
//                        @Override
//                        public void onFailure(@NonNull Exception e) {
//                            Log.w(TAG, "getDynamicLink:onFailure", e);
//                        }
//                    });

        }
    }


    /**
     * 用于在Base 中 实现Butterknife.bind()的功能
     *
     * @param binder 实现 ButterKnifeBinder.bindView() 方法，在其中做Butterknife.bind() ，功能
     */
    public static void setButterKnifeBinder(ButterKnifeBinder binder) {
        butterKnifeBinder = binder;
    }

    public static Object bindView(Object obj, View view) {
        if (butterKnifeBinder != null) {
            return butterKnifeBinder.bindView(obj, view);
        }
        return null;
    }

    public static void unBindView(Object unBinder) {
        if (butterKnifeBinder != null) {
            butterKnifeBinder.unBind(unBinder);
        }
    }

    public interface ButterKnifeBinder {
        Object bindView(Object obj, View view);

        void unBind(Object obj);
    }

    /**
     * SmartRefresh 默认风格
     * */
    static {
        //设置全局的Header构建器
        SmartRefreshLayout.setDefaultRefreshHeaderCreator(new DefaultRefreshHeaderCreator() {
            @Override
            public RefreshHeader createRefreshHeader(Context context, RefreshLayout layout) {
                layout.setPrimaryColorsId(R.color.qmui_config_color_gray_9, R.color.qmui_config_color_50_pure_black);//全局设置主题颜色
                return new ClassicsHeader(context);//.setTimeFormat(new DynamicTimeFormat("更新于 %s"));//指定为经典Header，默认是 贝塞尔雷达Header
            }
        });
        //设置全局的Footer构建器
        SmartRefreshLayout.setDefaultRefreshFooterCreator(new DefaultRefreshFooterCreator() {
            @Override
            public RefreshFooter createRefreshFooter(Context context, RefreshLayout layout) {
                //指定为经典Footer，默认是 BallPulseFooter
                return new ClassicsFooter(context).setDrawableSize(20);
            }
        });
    }

}
