package tech.starwin.utils;

import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import android.provider.ContactsContract;

/**
 * Created by SiKang on 2018/10/19.
 * 数据库辅助类，用于涉及数据库查询的业务封装
 */
public class DataBaseHelper {

    /**
     * 查询联系人信息
     *
     * @return String[name, number]
     */
    public static String[] queryContactInfo(Context context, Uri uri) {
        String[] data = null;
        if (uri != null) {
            Cursor cursor = context.getContentResolver()
                    .query(uri, new String[]{ContactsContract.CommonDataKinds.Phone.NUMBER,
                                    ContactsContract.CommonDataKinds.Phone.DISPLAY_NAME},
                            null, null, null);
            while (cursor != null && cursor.moveToNext()) {
                String number = cursor.getString(0);
                String name = cursor.getString(1);
                data = new String[]{name, number};
            }
            cursor.close();
        }
        return data;
    }
}
