package tech.starwin.utils.event_bus;

import android.support.annotation.NonNull;

import org.greenrobot.eventbus.EventBus;


/**
 * Created by SiKang on 2018/8/19.
 * 用来构建和发送 EventMessage
 */

public class EventSender {
    EventMessage message;

    private EventSender(EventMessage message) {
        this.message = message;
    }

    public void sendEvent() {
        EventBus.getDefault().post(message);
    }


    public static class Builder {
        EventMessage message;

        public Builder() {
            message = new EventMessage();
        }

        public Builder(int what) {
            message = new EventMessage();
            message.what = what;
        }

        public Builder what(int what) {
            message.what = what;
            return this;
        }

        public Builder msg(String msg) {
            message.msg = msg;
            return this;
        }

        public Builder obj(Object obj) {
            message.obj = obj;
            return this;
        }

        public Builder put(String key, Object value) {
            message.put(key, value);
            return this;
        }

        public Builder addFilter(@NonNull Class... filters) {
            for (Class filter : filters)
                message.addFilter(filter);
            return this;
        }

        public Builder addTarget(@NonNull Class... targets) {
            for (Class target : targets)
                message.addTarget(target);
            return this;
        }

        public EventSender build() {
            return new EventSender(message);
        }

    }
}
