package com.common.base;

import android.app.Activity;
import android.content.Context;
import android.content.res.Configuration;
import android.os.Bundle;
import android.support.multidex.MultiDex;
import android.support.multidex.MultiDexApplication;
import android.util.Log;
import android.view.Gravity;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;

import com.jcminarro.philology.Philology;
import com.jcminarro.philology.PhilologyInterceptor;
import com.jcminarro.philology.PhilologyRepository;
import com.jcminarro.philology.PhilologyRepositoryFactory;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import io.github.inflationx.viewpump.ViewPump;
import tech.starwin.LibConfig;
import tech.starwin.network.Gateway;
import tech.starwin.utils.InstallReferrerHelper;
import tech.starwin.utils.context_utils.AppLanguageUtils;
import tech.starwin.utils.format_utils.StringDecrypt;

/**
 * Created by SiKang on 2018/11/2.
 */
public abstract class BaseApplication extends MultiDexApplication {

    @Override
    protected void attachBaseContext(Context base) {
        initLibCnofig();
        super.attachBaseContext(AppLanguageUtils.attachBaseContext(base, LibConfig.LANGUAGE));
        MultiDex.install(this);
    }


    @Override
    public void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        AppLanguageUtils.setLanguage(this, LibConfig.LANGUAGE);
    }


    @Override
    public void onCreate() {
        super.onCreate();

        AppLanguageUtils.setLanguage(this, LibConfig.LANGUAGE);

        PhilologyRepositoryFactory repositoryFactory = locale -> new DefaultPhilologyRepository();
//        ViewTransformerFactory viewTransformerFactory = view -> new TextViewTransformer();
        Philology.INSTANCE.init(repositoryFactory);
        ViewPump.init(ViewPump.builder().addInterceptor(PhilologyInterceptor.INSTANCE).build());

        InstallReferrerHelper.refershInstallReferrer(this);

        LibConfig.initLib(this);

//        //已签名的APP，这里会输出当前签名的 hashCode 值，将 hashCode 在服务端备份（更换签名时要同时更新备份）
//        LogUtils.d("Signal_Log", "hashCode: " + JNISignal.getKeyStoreHashCode(this));
//        /*
//         * 获取暗号，每一个 http 请求，都在 header 中加入此暗号
//         * 服务端收到请求，根据header中的包名和已备份的hashCode，用同样的方式生成暗号，然后和 Header 中收到的暗号进行对比，如果暗号不一样，则拒绝返回数据
//         * */
//        LogUtils.d("Signal_Log", "signal: " + JNISignal.getSignal(this));
    }

    public class DefaultPhilologyRepository implements PhilologyRepository {
        @Nullable
        @Override
        public CharSequence getText(@NotNull String key) {
            try {
                int resId = getResources().getIdentifier(key, "string", LibConfig.APPLICATION_ID);
                return StringDecrypt.uncodeString(getResources().getString(resId));
            } catch (Exception e) {
                return "--";
            }
        }
    }


    /**
     * before onCreate()
     */
    public abstract void initLibCnofig();

}
