package tech.starwin.utils.collection;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;


import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Date;

import tech.starwin.utils.LoginManager;

/**
 * 异常处理
 */
public class ExceptionHelper {
    public static String throwable2String(Throwable ex) {
        Writer writer = new StringWriter();
        PrintWriter printWriter = new PrintWriter(writer);
        ex.printStackTrace(printWriter);
        Throwable cause = ex.getCause();
        while (cause != null) {
            cause.printStackTrace(printWriter);
            cause = cause.getCause();
        }
        printWriter.close();
        return writer.toString();
    }

    public static JSONObject getCrashMsgBody(Context context, String crashMsg, String tag) {
        JSONObject CrashMsgEntity = new JSONObject();
        Long totalNumber = 1L;
        Long latestTime = 0L;
        Long earliestTime = 0L;

        JSONArray crashMsgArray = new JSONArray();

        JSONObject crashMsgObject = new JSONObject();

        try {
            crashMsgObject.put("createTime", new Date().getTime());
            crashMsgObject.put("crashMsg", crashMsg);
            crashMsgArray.put(crashMsgObject);

            //------------------------
            PackageInfo packageInfo = context.getPackageManager().getPackageInfo(context.getPackageName(), 0);
            CrashMsgEntity.put("protocolName", "CRASH_MSG");
            CrashMsgEntity.put("protocolVersion", ProtocolVersion.V_1_0.name());
            CrashMsgEntity.put("versionName", packageInfo.versionName);
            CrashMsgEntity.put("versionCode", packageInfo.versionCode);

            CrashMsgEntity.put("totalNumber", totalNumber);
            CrashMsgEntity.put("latestTime", latestTime);
            CrashMsgEntity.put("earliestTime", earliestTime);

            CrashMsgEntity.put("token", LoginManager.get().getToken());

            CrashMsgEntity.put("tag", tag);

            CrashMsgEntity.put("data", crashMsgArray);

        } catch (JSONException e) {
            e.printStackTrace();
        } catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }

        return CrashMsgEntity;
    }

    public static JSONObject getInstallRefererMsgBody(Context context, String msg, String tag) {
        JSONObject CrashMsgEntity = new JSONObject();
        Long totalNumber = 1L;
        Long latestTime = 0L;
        Long earliestTime = 0L;

        JSONArray crashMsgArray = new JSONArray();

        JSONObject crashMsgObject = new JSONObject();

        try {
            crashMsgObject.put("createTime", new Date().getTime());
            crashMsgObject.put("msg", msg);
            crashMsgArray.put(crashMsgObject);

            //------------------------
            PackageInfo packageInfo = context.getPackageManager().getPackageInfo(context.getPackageName(), 0);
            CrashMsgEntity.put("protocolName", "CRASH_MSG");
            CrashMsgEntity.put("protocolVersion", ProtocolVersion.V_1_0.name());
            CrashMsgEntity.put("versionName", packageInfo.versionName);
            CrashMsgEntity.put("versionCode", packageInfo.versionCode);

            CrashMsgEntity.put("totalNumber", totalNumber);
            CrashMsgEntity.put("latestTime", latestTime);
            CrashMsgEntity.put("earliestTime", earliestTime);

            String token = LoginManager.get().getToken();
            if (token == null) {
                token = "";
            }
            CrashMsgEntity.put("token", token);

            CrashMsgEntity.put("tag", tag);

            CrashMsgEntity.put("data", crashMsgArray);

        } catch (JSONException e) {
            e.printStackTrace();
        } catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }

        return CrashMsgEntity;
    }
}