package tech.starwin.mvp.ui.activity;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.support.annotation.Nullable;

import java.lang.reflect.Field;
import java.lang.reflect.Method;

import tech.starwin.BuildConfig;
import tech.starwin.LibConfig;
import tech.starwin.utils.GeneralUtils;
import tech.starwin.utils.LoginManager;
import tech.starwin.utils.ui_utils.UIHelper;
import zendesk.suas.Action;
import zendesk.support.request.RequestActivity;
import zendesk.support.request.RequestUiConfig;

public class RefreshDeskActivity extends RequestActivity {

    private static final long LOOP_TIME = 1500;
    private Handler mHandler = new Handler();
    private Field mAfField = null;
    private Method mRefreshCommentMethod;
    private Field mStoreField = null;
    private Method mDispatchMethod;
    private Object mAf = null;
    private Object mStore = null;
    private boolean mIsPaused = false;

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);

        try {
            mAfField = RequestActivity.class.getDeclaredField("af");
            mAfField.setAccessible(true);

            mStoreField = RequestActivity.class.getDeclaredField("store");
            mStoreField.setAccessible(true);

            mAf = mAfField.get(this);
            mStore = mStoreField.get(this);

            mRefreshCommentMethod = mAf.getClass().getDeclaredMethod("updateCommentsAsync");
            mRefreshCommentMethod.setAccessible(true);

            mDispatchMethod = mStore.getClass().getDeclaredMethod("dispatch", Action.class);
            mDispatchMethod.setAccessible(true);
        } catch (Exception e) {
            e.printStackTrace();
            finish();
            return;
        }
    }

    /**
     * 启动会话界面
     */
    public static void start(Context context) {
        RequestUiConfig.Builder config = new RequestUiConfig.Builder();
        config.withRequestSubject(LoginManager.get().getTokenInfo().getMobile());
        Intent intent = RequestActivity.builder()
                .withTags("2.0", LibConfig.VERSION_NAME + LibConfig.VERSION_CODE)
                .intent(context, config.config());
        context.startActivity(intent);
    }

    private void refresh() {
        try {
            mDispatchMethod.invoke(mStore, mRefreshCommentMethod.invoke(mAf));
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    protected void onResume() {
        super.onResume();
        mIsPaused = false;
        mHandler.postDelayed(new Runnable() {
            @Override
            public void run() {
                if (isFinishing() || mIsPaused) {
                    return;
                }
                refresh();
                mHandler.postDelayed(this, LOOP_TIME);
            }
        }, LOOP_TIME);
    }

    @Override
    protected void onPause() {
        super.onPause();
        mIsPaused = true;
        mHandler.removeCallbacksAndMessages(null);
    }

    @Override
    protected void onStop() {
        super.onStop();
        if (isFinishing()) {
            mHandler.removeCallbacksAndMessages(null);
        }
        UIHelper.closeKeybord(this);
    }
}
