#-*-coding:utf-8-*-
import os
import sys
import random
from PIL import Image, ImageDraw, ImageFont


text = ["Mudah Diajukan\n   Pengisian Data Tidak Rumit",\
    "Tidak bisa menyelesaikan masalah?\nKhawatir tentang masalah pendanaan?",\
        "Pinjaman Dana Santai\n  Cepat Masuk dalam Rekening",\
        "Isi informasi dengan mudah dan\nkeluar dari hutan dengan cepat",\
        "Memberikan anda layanan \n     pinjaman berkualitas",\
        "Membantu Anda mengatasi\n     kesulitan keuangan",\
        "Aliran Dana Untuk Anda\n     Uangmu Tercukupi Di Sini",\
        "Pinjaman Semakin Nyaman\n     Kangan Ragu! Unduh APPnya",\
        "Ambil Keberuntungan Kamu\n     Bersama Kami Duitmu Beres",\
        "Membantu Anda keluar dari masalah\     dan menyelesaikan kesulitan keuangan",\
        "Hadir Utk Area Indonesia\n     Layanan Pelanggan Sapa Ramah"]
def draw_bg(bg_path,logo_path,top_path,output):
    
    img_bg = Image.open(bg_path)
    img_logo = Image.open(logo_path)
    img_top = Image.open(top_path)
    
    text_h = random.randint(0,1400)
    logo_h = random.randint(0,1400)
    top_h = random.randint(0,1400)
    text_index = random.randint(0,len(text)-1)

    while abs(logo_h - text_h) < 400 or abs(top_h - text_h) < 400:
        logo_h = random.randint(0,1400)
        top_h = random.randint(0,1400)

    # 添加背景
    new_img = Image.new('RGBA', (img_bg.size[0] * 2, img_bg.size[1]), (0, 0, 0, 0))
    new_img.paste(img_bg, (0,0))
    new_img.paste(img_bg, (img_bg.size[0],0))
    img_logo = img_logo.resize((300, 300),Image.ANTIALIAS)
    img_top = img_top.resize((700, 342),Image.ANTIALIAS)
    
    #logo随机位置
    new_img.paste(img_logo, (random.randint(0,700),logo_h),mask=img_logo)
    new_img.paste(img_top, (1080,top_h))

    # 字体随机大小
    font_size = random.randint(120, 180)
    font = ImageFont.truetype('Arial.ttf', font_size)
    # 添加字体
    new_img = new_img.convert('RGBA')
    img_text = Image.new('RGBA', new_img.size, (255, 255, 255, 0))
    image_draw = ImageDraw.Draw(img_text)

    image_draw.text((random.randint(0,300), text_h), text[text_index], font=font, fill="#FFFFFF")
    bg_with_text = Image.alpha_composite(new_img, img_text)

    # 裁切图片
    screen1 = bg_with_text.crop((0, 0, img_bg.size[0], img_bg.size[1]))
    screen2 = bg_with_text.crop((img_bg.size[0], 0, img_bg.size[0]*2, img_bg.size[1]))
    screen1.save(output+"screen1.png","PNG")
    screen2.save(output+"screen2.png","PNG")



draw_bg(sys.argv[1],sys.argv[2],sys.argv[3],sys.argv[4])
