package com.common.fragment;

import android.app.Activity;
import android.os.Bundle;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import android.view.ViewGroup;

import java.io.Serializable;

import tech.starwin.R;
import com.common.base.BaseFragment;
import tech.starwin.base.BaseRecyclerAdapter;
import com.common.bean.RegionBean;
import tech.starwin.mvp.presenter.UserPresenter;
import com.common.activity.RegionActivity;
import tech.starwin.mvp.ui.adapter.RegionAdapter;
import tech.starwin.utils.context_utils.ActivityJumper;
import tech.starwin.utils.event_bus.EventSender;
import tech.starwin.utils.ui_utils.UIHelper;

/**
 * Created by SiKang on 2018/9/27.
 */
public class RegionFragment extends BaseFragment {
    /**
     * 区域级别
     */
    public class RegionLevel {
        public static final String PROVINCE = "province";
        public static final String CITY = "city";
        public static final String DISTRICT = "district";
        public static final String AREA = "area";
    }

    /**
     * 当前选好的地址
     */
    public static class RegionInfo implements Serializable {
        public String province;
        public String city;
        public String district;
        public String area;

        @Override
        public String toString() {
            return (province == null ? "" : province) + " " +
                    (city == null ? "" : city) + " " +
                    (district == null ? "" : district) + " " +
                    (district == null ? "" : district);
        }
    }

    private RecyclerView mRegionRv;
    private RegionInfo regionInfo;

    @Override
    public int bindLayout() {
        return R.layout.fragment_region;
    }

    @Override
    public boolean useTopBar() {
        return false;
    }


    @Override
    public void initView(ViewGroup contentView) {
        mRegionRv = contentView.findViewById(R.id.fragment_region_rv);
        //要显示的地区分级
        RegionBean.RegionsBean regionBean;
        Bundle arguments = getArguments();
        if (arguments != null && arguments.getSerializable("regionLevel") != null) {
            regionBean = (RegionBean.RegionsBean) getArguments().getSerializable("regionLevel");
        } else {
            regionBean = new RegionBean.RegionsBean(1, RegionLevel.PROVINCE, RegionLevel.PROVINCE);
        }
        //已经选好的部分
        if (arguments != null && arguments.getSerializable("region_info") != null) {
            regionInfo = (RegionInfo) getArguments().getSerializable("region_info");
        } else {
            regionInfo = new RegionInfo();
        }

        //设置标题
        int titleId = 0;
        switch (regionBean.getLevel()) {
            case RegionLevel.PROVINCE:
                titleId = R.string.text_personal_info_province_of_residence;
                break;
            case RegionLevel.CITY:
                titleId = R.string.text_personal_info_city_of_residence;
                break;
            case RegionLevel.DISTRICT:
                titleId = R.string.text_personal_info_street_of_residence;
                break;
            case RegionLevel.AREA:
                titleId = R.string.text_personal_info_area_of_residence;
                break;
        }
        new EventSender.Builder(RegionActivity.CHANGE_REGION_TITLE).msg(getString(titleId)).build().sendEvent();

        //获取地区列表
        getPresenter(UserPresenter.class).getRegion("action_getRegion", regionBean.getLevel(), regionBean.getId());
    }

    /**
     * 创建实例
     */
    public static RegionFragment create(RegionBean.RegionsBean regionsBean) {
        RegionFragment fragment = new RegionFragment();
        fragment.setArguments(new ActivityJumper.Builder().put("regionLevel", regionsBean).toBundle());
        return fragment;
    }

    @Override
    public void onHttpSuccess(String action, Object result) {
        if (action == "action_getRegion") {
            //填充数据，更新UI
            final RegionBean regionBean = (RegionBean) result;
            if (regionBean.getRegions().size() == 0) {
                getActivity().setResult(Activity.RESULT_OK, new ActivityJumper.Builder().put("region_info", regionInfo).toIntent());
                getActivity().finish();
            }
            RegionAdapter regionAdapter = new RegionAdapter(getActivity(), regionBean.getRegions());
            UIHelper.bindAdapter(mRegionRv, regionAdapter);
            //选中区域 item
            regionAdapter.setOnItemClickListener(new BaseRecyclerAdapter.OnItemClickListener<RegionBean.RegionsBean>() {
                @Override
                public void onItemClick(View itemView, int pos, RegionBean.RegionsBean regionsBean) {
                    //
                    switch (regionsBean.getLevel()) {
                        case RegionLevel.PROVINCE:
                            regionInfo.province = regionsBean.getName();
                            regionsBean.setLevel(RegionLevel.CITY);
                            break;
                        case RegionLevel.CITY:
                            regionInfo.city = regionsBean.getName();
                            regionsBean.setLevel(RegionLevel.DISTRICT);
                            break;
                        case RegionLevel.DISTRICT:
                            regionInfo.district = regionsBean.getName();
                            regionsBean.setLevel(RegionLevel.AREA);
                            break;
                        case RegionLevel.AREA:
                            regionInfo.area = regionsBean.getName();
                            //最后一级选择完成，关闭界面，返回数据
                            getActivity().setResult(Activity.RESULT_OK, new ActivityJumper.Builder().put("region_info", regionInfo).toIntent());
                            getActivity().finish();
                            return;
                    }
                    //下一级
                    RegionFragment fragment = create(regionsBean);
                    fragment.getArguments().putSerializable("region_info", regionInfo);
                    startFragmentAndDestroyCurrent(fragment, true);
                }
            });
        }
    }
}
