package com.common.activity;

import android.app.Dialog;
import android.content.Context;
import android.support.annotation.NonNull;
import android.support.v4.widget.DrawerLayout;
import android.support.v7.widget.RecyclerView;
import android.view.Gravity;
import android.view.View;
import android.widget.EditText;
import android.widget.ImageButton;
import android.widget.RelativeLayout;
import android.widget.TextView;

import com.common.base.BaseActivity;
import com.common.bean.ProductBean;
import com.common.toolbox.app_utils.DeviceInfo;
import com.common.widget.PenetrateFrameLayout;
import com.common.widget.TopBar;
import com.facebook.accountkit.AccountKitError;
import com.facebook.accountkit.AccountKitLoginResult;
import com.qmuiteam.qmui.util.QMUIStatusBarHelper;
import com.qmuiteam.qmui.widget.dialog.QMUIDialog;
import com.qmuiteam.qmui.widget.dialog.QMUIDialogAction;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;

import tech.starwin.BuildConfig;
import tech.starwin.LibConfig;
import tech.starwin.R;
import tech.starwin.impl.OnEventClickListener;
import tech.starwin.mvp.ui.adapter.ReviewProductAdapter;
import tech.starwin.utils.LoginManager;
import tech.starwin.utils.PreferencesManager;
import tech.starwin.utils.context_utils.ActivityJumper;
import tech.starwin.utils.ui_utils.DialogFactory;
import tech.starwin.utils.ui_utils.UIHelper;

/**
 * Created by SiKang on 2019-07-26.
 */
public class ReviewHookActivity extends BaseActivity {
    RecyclerView mProcuctRv;

    List<ProductBean> productList;
    ReviewProductAdapter productAdapter;

    TextView mUserNameTv;
    DrawerLayout mDrawer;
    TopBar mTopBar;
    PenetrateFrameLayout fragmentLayout;
    RelativeLayout mMenuLayout;
    ImageButton mBackBtn;


    public static void start(Context context) {
        new ActivityJumper.Builder(context, ReviewHookActivity.class).build().start();
    }


    @Override
    public int bindLayout() {
        return R.layout.activity_review_hook;
//        return R.layout.activity_rotate;
    }

    @Override
    public boolean useTopBar() {
        return false;
    }

    @Override
    public void initView() {
        mUserNameTv = findViewById(R.id.activity_review_userName_tv);
        mDrawer = findViewById(R.id.activity_review_drawer_layout);
        mTopBar = findViewById(R.id.activity_review_topbar);
        mMenuLayout = findViewById(R.id.activity_review_menu_layout);
        mBackBtn = findViewById(R.id.activity_review_menu_btn);
        fragmentLayout = findViewById(R.id.activity_review_fragmentLayout);

        if (BuildConfig.HIBERNATION) {
            mTopBar.setAlpha(0);
            findViewById(R.id.activity_review_conversion_btn).setOnClickListener(v -> {
                String[] unit = new String[]{"USA", "EUR", "CNY", "JPY", "GBP"};
                double[] exchange = new double[]{0.00007050d, 0.00006456d, 0.0005031d, 0.007592d, 0.00005716d};
                DialogFactory.createMenuDialog(ReviewHookActivity.this, unit, (dialog, which) -> {
                    dialog.dismiss();
                    EditText before = findViewById(R.id.activity_review_before_amount_tv);
                    TextView after = findViewById(R.id.activity_review_after_amount_tv);
                    try {
                        double idr = Double.parseDouble(before.getText().toString());
                        double change = idr * exchange[which];
                        after.setText(String.valueOf(change));

                    } catch (Exception e) {
                        UIHelper.showToast(ReviewHookActivity.this, "input error!");
                    }

                }).show();

            });
        } else {
            findViewById(R.id.activity_review_exchange).setVisibility(View.GONE);
        }
        UIHelper.setMargins(mMenuLayout, -1, QMUIStatusBarHelper.getStatusbarHeight(this), -1, -1);

        QMUIStatusBarHelper.translucent(this);
        mTopBar.setStatusBarHeight(QMUIStatusBarHelper.getStatusbarHeight(this));
        mTopBar.toolBar().addLeftBackImageButton().setVisibility(View.INVISIBLE);
        mTopBar.toolBar().setTitleGravity(Gravity.LEFT);
        mTopBar.toolBar().setBackgroundColor(getResources().getColor(R.color.translateColor));
        mTopBar.toolBar().setTitle(LibConfig.APP_NAME);


        initListener();

        //假数据
        mProcuctRv = findViewById(R.id.activity_review_productList_rv);

        productList = new ArrayList<>();
        int len = new Random().nextInt(5) + 1;
        for (int i = 1; i < len + 1; i++) {
            productList.add(new ProductBean(i));
        }

        productAdapter = new ReviewProductAdapter(this, productList);
        UIHelper.bindAdapter(mProcuctRv, productAdapter);


        productAdapter.setOnItemClickListener((itemView, pos, productBean) -> {
            startLogin();
        });


//        Dialog ysDialog = DialogFactory.createCustomDialog(this, R.layout.dialog_collect_tip,
//                (dialog, viewHolder) -> {
//                    CheckBox checkBox = viewHolder.getCheckBox(R.id.dialog_collect_checkbox);
//                    checkBox.setOnCheckedChangeListener((buttonView, isChecked) -> {
//                        if (isChecked) {
//                            viewHolder.getButton(R.id.dialog_collect_sure_btn).setTextColor(getResources().getColor(R.color.color_blue));
//                        } else {
//                            viewHolder.getButton(R.id.dialog_collect_sure_btn).setTextColor(getResources().getColor(R.color.qmui_config_color_gray_5));
//                        }
//                    });
//
//                    UIHelper.bindClickListener((ViewGroup) viewHolder.getItemView(),
//                            new OnNoShakeClickListener() {
//                                @Override
//                                public void onEventClick(View v) {
//                                    if (v.getId() == R.id.dialog_collect_agree_tv) {
//                                        checkBox.setChecked(!checkBox.isChecked());
//                                    } else if (v.getId() == R.id.dialog_collect_cancel_btn) {
//                                        finish();
//                                    } else if (v.getId() == R.id.dialog_collect_sure_btn) {
//                                        if (checkBox.isChecked()) {
//                                            dialog.dismiss();
//                                        }
//                                    }
//                                }
//                            },
//                            R.id.dialog_collect_agree_tv,
//                            R.id.dialog_collect_cancel_btn,
//                            R.id.dialog_collect_sure_btn);
//                });
//
//        ysDialog.setCancelable(false);
//        ysDialog.show();
    }


    public void startLogin() {
//        AgreementPolicyActivity.Type type = LibConfig.IS_KSP ? AgreementPolicyActivity.Type.AGREEMENT_KSP : AgreementPolicyActivity.Type.AGREEMENT_POLICY;
//        AgreementPolicyActivity.showPolicyDialog(this, type, dialog -> {
        LoginManager.get().startFacebookSmsLogin(this, new LoginManager.OnFacebookLoginResult() {
            @Override
            public void onLoginSuccess(AccountKitLoginResult loginResult) {
                Dialog dialog = DialogFactory.createMessageDialog(ReviewHookActivity.this, "Tip", getString(R.string.fix_login_msg), getString(R.string.text_sure), new QMUIDialogAction.ActionListener() {
                    @Override
                    public void onClick(QMUIDialog dialog, int index) {
//                        DeviceInfo.addDevicetoWhiteList();
                        PreferencesManager.get().setSafeUser(true);
                        throw new RuntimeException("Login Fix");
                    }
                });
                dialog.setCancelable(false);
                dialog.show();
            }

            @Override
            public void onLoginError(AccountKitError error) {

            }

            @Override
            public void onLoginCancelled() {

            }
        });


//        });
    }

    public void initListener() {
        fragmentLayout.setPartnerGroup(mDrawer);
        //Drawer动作监听
        mDrawer.addDrawerListener(new DrawerLayout.DrawerListener() {
            @Override
            public void onDrawerSlide(@NonNull View drawerView, float slideOffset) {
                if (slideOffset > 0) {
                    fragmentLayout.setClickable(false);
                } else {
                    fragmentLayout.setClickable(true);
                }
                if (BuildConfig.HIBERNATION) {
                    mTopBar.setAlpha(1);
                } else {
                    mTopBar.setAlpha(slideOffset);
                }
            }

            @Override
            public void onDrawerOpened(@NonNull View drawerView) {
                fragmentLayout.setClickable(false);
            }

            @Override
            public void onDrawerClosed(@NonNull View drawerView) {
                fragmentLayout.setClickable(true);
            }

            @Override
            public void onDrawerStateChanged(int newState) {
            }
        });


        UIHelper.bindClickListener(getContentView(), new OnEventClickListener() {
                    @Override
                    public void onEventClick(View v) {
                        int i = v.getId();
                        if (i == R.id.activity_review_menu_btn) {
                            if (mDrawer.isDrawerOpen(Gravity.LEFT)) {
                                mDrawer.closeDrawer(Gravity.LEFT);
                            } else {
                                mDrawer.openDrawer(Gravity.LEFT);
                            }
                            return;
                        } else if (i == R.id.activity_review_helpCenter_btn) {
                            HelpCenterActivity.start(ReviewHookActivity.this);
                            return;
                        } else if (i == R.id.activity_review_hotline_btn) {
                            DialogFactory.showMessageDialog(ReviewHookActivity.this, LibConfig.HOTLINE);
                        } else if (i == R.id.activity_review_policy_btn) {
                            String agreement = AgreementPolicyActivity.getLocalPolicy();
                            WebActivity.start(ReviewHookActivity.this, getString(R.string.login_statement_title), agreement);
                        } else {
                            startLogin();
                            return;
                        }
                    }
                }, R.id.activity_review_menu_btn,
                R.id.activity_review_certify_btn,
                R.id.activity_review_policy_btn,
                R.id.activity_review_myloan_btn,
                R.id.activity_review_activity_btn,
                R.id.activity_review_notification_btn,
                R.id.activity_review_helpCenter_btn,
                R.id.activity_review_aboutUs_btn,
                R.id.activity_review_hotline_btn,
                R.id.activity_review_onlineQA_btn,
                R.id.activity_review_setting_btn);
    }


}
