package tech.starwin.utils.format_utils;

import android.util.Base64;
import android.view.View;
import android.view.ViewGroup;
import android.widget.EdgeEffect;
import android.widget.EditText;
import android.widget.TextView;

import java.util.Stack;

/**
 * Created by SiKang on 2019/5/23.
 */
public class StringDecrypt {
    public static final String FLAG = "#-#";

    public static String uncodeString(String text) {
        if (text.contains(FLAG)) {
            String key = text.split(FLAG)[0];
            String value = text.split(FLAG)[1];
            value = new String(Base64.decode(value.getBytes(), Base64.DEFAULT));
            if (value.startsWith(key)) {
                value.replace(key, "");
            }
            return value;
        }
        return text;
    }

    public static void uncode(ViewGroup viewGroup) {
        Stack stack = new Stack();
        for (int i = 0; i < viewGroup.getChildCount(); i++) {
            View view = viewGroup.getChildAt(i);
            if (view instanceof TextView) {
                uncode((TextView) view);
            } else if (view instanceof EditText) {
                uncode((EditText) view);
            } else if (view instanceof ViewGroup) {
                stack.push(viewGroup);
            }
        }

    }

    public static void uncode(TextView textView) {
        String text = uncodeString(textView.getText().toString());
        textView.setText(text);
    }

    public static void uncode(EditText editText) {
        String text = uncodeString(editText.getText().toString());
        editText.setText(text);
    }
}
