package com.common.base;

import android.app.Activity;
import android.content.Context;
import android.content.res.Configuration;
import android.os.Bundle;
import android.support.multidex.MultiDex;
import android.support.multidex.MultiDexApplication;
import android.text.TextUtils;
import android.util.Log;


import com.facebook.FacebookSdk;
import com.facebook.accountkit.internal.AccountKitController;
import com.facebook.accountkit.internal.Initializer;
import com.facebook.libfbref.FbDeepLink;

import java.lang.reflect.Field;

import tech.starwin.BuildConfig;
import tech.starwin.LibConfig;
import tech.starwin.network.Gateway;
import tech.starwin.utils.AccountKitUtils;
import tech.starwin.utils.InstallReferrerHelper;
import tech.starwin.utils.PreferencesManager;
import tech.starwin.utils.RequestHandler;
import tech.starwin.utils.TrackEventHelper;
import tech.starwin.utils.context_utils.AppLanguageUtils;
import tech.starwin.utils.context_utils.DeviceUtils;
import tech.starwin.utils.format_utils.StringDecrypt;
import tech.starwin.utils.format_utils.StringFormat;

/**
 * Created by SiKang on 2018/11/2.
 */
public abstract class BaseApplication extends MultiDexApplication {

    @Override
    protected void attachBaseContext(Context base) {
        DeviceUtils.getInstance().init(base);
        initLibCnofig();
//        Context languageContext = AppLanguageUtils.attachBaseContext(base, LibConfig.LANGUAGE);
//        super.attachBaseContext(ViewPumpContextWrapper.wrap(Philology.INSTANCE.wrap(languageContext)));
        super.attachBaseContext(AppLanguageUtils.attachBaseContext(base, LibConfig.LANGUAGE));
        MultiDex.install(this);
    }


    @Override
    public void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        AppLanguageUtils.setLanguage(this, LibConfig.LANGUAGE);
    }


    @Override
    public void onCreate() {
        super.onCreate();
        FbDeepLink.getFbReferrer();
//        if (!TextUtils.isEmpty(LibConfig.BUGLY_APPID)) {
//            CrashReport.initCrashReport(getApplicationContext(), LibConfig.BUGLY_APPID, false);
//        }

//        try {
//
//            String appId = StringDecrypt.uncodeString(BuildConfig.FACEBOOK_APP_ID);
//
//            String clienToken = StringDecrypt.uncodeString(BuildConfig.ACCOUNT_KIT_CLIENT_TOKEN);
//
//            FacebookSdk.setApplicationId(appId);
//
//            FacebookSdk.setApplicationName(LibConfig.APP_NAME);
//
//            FacebookSdk.setClientToken(clienToken);
//
//            FacebookSdk.sdkInitialize(this);
//
//            AccountKitUtils.initAccountKit(appId, LibConfig.APP_NAME, clienToken);
//
//        } catch (Exception e) {
//
//            Log.e("AccountKitUtils", "Failed to auto initialize the Facebook SDK", e);
//        }

        AppLanguageUtils.setLanguage(this, LibConfig.LANGUAGE);

//        PhilologyRepositoryFactory repositoryFactory = locale -> new DefaultPhilologyRepository();
////        ViewTransformerFactory viewTransformerFactory = view -> new TextViewTransformer();
//        Philology.INSTANCE.init(repositoryFactory);
//        ViewPump.init(ViewPump.builder().addInterceptor(PhilologyInterceptor.INSTANCE).build());


        InstallReferrerHelper.refershInstallReferrer(this);


        LibConfig.initLib(this);


    }

//    public class DefaultPhilologyRepository implements PhilologyRepository {
//        @Nullable
//        @Override
//        public CharSequence getText(@NotNull String key) {
//            try {
//                int resId = getResources().getIdentifier(key, "string", LibConfig.APPLICATION_ID);
//                return StringDecrypt.uncodeString(getResources().getString(resId));
//            } catch (Exception e) {
//                return "--";
//            }
//        }
//    }


    /**
     * before onCreate()
     */
    public abstract void initLibCnofig();


}
