package tech.starwin.utils;

import android.content.ActivityNotFoundException;
import android.content.Intent;
import android.support.v4.app.FragmentActivity;

import com.facebook.accountkit.AccountKitError;
import com.facebook.accountkit.AccountKitLoginResult;
import com.facebook.accountkit.ui.AccountKitActivity;
import com.facebook.accountkit.ui.AccountKitConfiguration;
import com.facebook.accountkit.ui.LoginType;

import tech.starwin.LibConfig;
import tech.starwin.mvp.beans.TokenInfoBean;
import tech.starwin.utils.activity_utils.EasyActivityResult;
import tech.starwin.utils.activity_utils.IntentHolder;

/**
 * Created by SiKang on 2018/9/19.
 */
public class LoginManager {
    private static LoginManager loginManager;
    private TokenInfoBean tokenInfo;

    private LoginManager() {
    }

    public static LoginManager get() {
        if (loginManager == null) {
            synchronized (LoginManager.class) {
                if (loginManager == null) {
                    loginManager = new LoginManager();
                }
            }
        }
        return loginManager;
    }

    /**
     * token失效，需要重新登录
     */
    public void tokenInvalid() {
        //清除登录状态
        PreferencesManager.get().clearLoginInfo();
        tokenInfo = null;
        try {
            //跳转登录界面
            new IntentHolder.Builder(LibConfig.getContext(), LibConfig.LOGIN_ACTIVITY_ACTION)
                    .build().start();
        } catch (ActivityNotFoundException e) {
            throw new RuntimeException("找不到LoginActivity，请在build.gradle中配置正确的 ‘LOGIN_ACTIVITY_ACTION’ ");
        }
    }


    /**
     * facebook 短信登录
     */
    public void startFacebookSmsLogin(FragmentActivity activity, final OnFacebookLoginResult result) {
        final Intent intent = new Intent(activity, AccountKitActivity.class);
        AccountKitConfiguration.AccountKitConfigurationBuilder configurationBuilder =
                new AccountKitConfiguration.AccountKitConfigurationBuilder(
                        LoginType.PHONE,
                        AccountKitActivity.ResponseType.CODE); // or .ResponseType.TOKEN
        intent.putExtra(AccountKitActivity.ACCOUNT_KIT_ACTIVITY_CONFIGURATION, configurationBuilder.build());

        new EasyActivityResult(activity).startForResult(intent, 0, new EasyActivityResult.OnResultListener() {
            @Override
            public void onActivityResult(int requestCode, int resultCode, Intent data) {
                if (requestCode == 0) { // confirm that this response matches your request
                    AccountKitLoginResult loginResult = data.getParcelableExtra(AccountKitLoginResult.RESULT_KEY);
                    if (loginResult.getError() != null) {
                        result.onLoginError(loginResult.getError());
                    } else if (loginResult.wasCancelled()) {
                        result.onLoginCancelled();
                    } else {
                        result.onLoginSuccess(loginResult);
                    }

                }
            }
        });
    }


    /**
     * 刷新Token
     */
    public void notifyTokenInfo(TokenInfoBean tokenInfo) {
        this.tokenInfo = tokenInfo;
        PreferencesManager.get().saveTokenInfo(tokenInfo);
    }

    /**
     * 获取Token
     */
    public String getToken() {
        return getTokenInfo() == null ? "" : tokenInfo.getToken();
    }

    public TokenInfoBean getTokenInfo() {
        if (tokenInfo == null) {
            tokenInfo = PreferencesManager.get().getTokenInfo();
        }
        return tokenInfo;
    }

    /**
     * 退出登录
     */
    public void logout() {
        tokenInfo = null;
        PreferencesManager.get().clearLoginInfo();
    }


    public interface OnFacebookLoginResult {
        void onLoginSuccess(AccountKitLoginResult loginResult);

        void onLoginError(AccountKitError error);

        void onLoginCancelled();
    }

}
