# -*-coding:utf-8-*-
import os


class Shell:

    # 编译 待开发
    def build_release(self, config):
        command = "%s\n%s\n%s\n%s\n%s\n%s\n%s\n%s\n" \
            % (
                "cd %s" % config['root'],
                "rm -rf resGuardApks",
                "gradlew clean",
                "cd lib_base/script/garble",
                "./insert.py || { echo \"insert_code error!\"; exit 1; }",
                "cd ../../../",
                "gradlew resguardAppProductGoogleplayRelease",
                "gradlew clean"
            )
        os.system(command)

    # commit&push project
    def push_project(self, config):
        command = "%s\n%s\n%s\n%s\n" \
            % (
                "cd %s" % config['root'],
                "git add .",
                "git commit -m \"%s\"" % (config['app_id'] +
                                          " " + config['version_name']),
                "git push origin %s" % config['git_branch']
            )
        os.system(command)

    # commit&push lib_base
    def push_base(self, config):
        commit_msg = input("输入commit msg: ")
        command = "%s\n%s\n%s\n%s\n" \
            % (
                "cd %s/%s" % (config['root'], "lib_base"),
                "git add .",
                "git commit -m \"%s\"" % commit_msg,
                "git push origin master"
            )
        os.system(command)

    # pull lib_base & cash_plugin_toolbox
    def pull_base(self, config):
        command = "%s\n%s\n%s\n%s\n%s\n%s\n%s\n%s\n%s\n%s\n%s\n" \
            % (
                "cd %s" % config['root'],
                "git submodule update --remote",
                "cd lib_base",
                "git checkout master",
                "git pull",
                "cd ../cash_plugin_toolbox",
                "git checkout master",
                "git pull",
                "cd ../lib_yitu || { echo \"lib_yitu not exist\"; exit 1; }",
                "git checkout master",
                "git pull"
            )
        os.system(command)

    # push with tag
    def push_with_tag(self, config):
        self.push_project(config)
        tagName = "t%s-%s" % (config['corp_id'], config['app_id'])
        command = "%s\n%s\n%s\n%s\n%s\n" \
            % (
                "cd %s" % config['root'],
                "git tag -d %s" % tagName,
                "git push origin --delete tag %s" % tagName,
                "git tag -a %s -m %s" % (tagName, tagName),
                "git push origin %s" % tagName,
            )
        os.system(command)

    # push with tag

    def reset_by_pkgname(self, config):
        pkgname = input("输入包名: ")
        command = "%s\n%s" \
            % (
                "cd %s" % config['root'],
                "git log --grep %s" % pkgname
            )
        os.system(command)
        print(" ")

        commit_id = input("输入commit id: ")

        command = "%s\n%s" \
            % (
                "cd %s" % config['root'],
                "git reset --hard %s" % commit_id
            )
        os.system(command)
        print(" ")

    # reset project
    def reset_project(self, config):
        command = "%s\n%s\n%s\n%s\n%s\n%s\n" \
            % (
                "cd %s" % config['root'],
                "git checkout . && git clean -df",
                "git reset --hard origin/%s" % config['git_branch'],
                "cd lib_base || { echo \"lib_base not exist!\"; exit 1; }",
                "git checkout . && git clean -df",
                "git reset --hard origin/master",
            )
        os.system(command)

    def jiagu(self, config):
        command = "%s\n%s\n%s\n%s\n"\
        %(
            "java -jar %s -login %s %s" % (config['jiagu_jar'], config['jiagu_account'], config["jiagu_pwd"]),
            "java -jar %s -importsign %s/app/%s %s %s %s"% (config['jiagu_jar'], config['root'], config['signing_certificate'], config['signging_certificatePassword'], config['signing_keyAlias'], config['signging_storePassword']),
            "java - jar %s - config - update - nocert" % config['jiagu_jar'],
            "java - jar %s - jiagu %s %s -autosign"% (config['jiagu_jar'], config['apk_path'], config['apk_path'])
        )
        os.system(command)