#!/usr/bin/env python3
import json
import string
import random
import glob, os

used_names = []
activity_mangle_setting = {}


# rand string for class names
def gen_rand_str():
    rand_str = ''.join(random.choices(string.ascii_uppercase + string.ascii_lowercase, k=8))
    while rand_str in used_names:
        rand_str = ''.join(random.choices(string.ascii_uppercase + string.ascii_lowercase, k=8))

    used_names.append(rand_str)
    return rand_str


def get_rand_code():
    code = ""
    num = random.randint(0, 5);
    if num == 0:
        code += ";\nString " + gen_rand_str() + "=\"" + gen_rand_str() + "\";\n"
    elif num == 1:
        code += ";\nint " + gen_rand_str() + "=\"" + random.randint(0, 100000) + "\";\n"
    elif num == 3:
        code += ";\nif(\"" + gen_rand_str() + "\".equals(\"" + gen_rand_str() + "\")){}\n"
    elif num == 4:
        index = gen_rand_str()
        code += ";\nfor(int " + index + "="+random.randint(0,10)+";"+index+"<"+random.randint(11,20)+";"+index+"++){}\n"
    return code


def process_file_content(path, file_name):
    print("processing content: %s..." % path)
    with open(path, "r", encoding="utf-8") as f:
        # readlines以列表的形式将文件读出
        lines = f.readlines()

    with open(path, "w", encoding="utf-8") as f_w:
        for line in lines:
            if ";\n" in line and "return" not in line and "break" not in line and "continue" not in line and "import" not in line and "package" not in line:
                line = line.replace(";\n", get_rand_code())
            f_w.write(line)
        print("done\n")
    return


# read configs
with open('obact.json', "rt") as f:
    json_root = json.load(f)
    activities = json_root["activities"]
    source_root = json_root["root"]
    manifest = json_root["manifest"]

# mangle activity names
for act_name in activities:
    activity_mangle_setting[act_name] = gen_rand_str()

root_path = os.path.join(os.getcwd(), source_root)
# perform content replace for the files
print("processing file content...")
for root, dirs, files in os.walk(source_root):
    directory = os.path.join(os.getcwd(), root)
    for file in files:
        if file.endswith(".java"):
            # get the path of the java file
            path = os.path.join(directory, file)

            process_file_content(path, file)
print("processing file content done")
