package com.common.widget;

import android.animation.ObjectAnimator;
import android.app.Dialog;
import android.content.Context;
import android.support.annotation.NonNull;
import android.view.LayoutInflater;
import android.view.View;
import android.view.animation.Animation;
import android.widget.ImageView;

import tech.starwin.LibConfig;
import tech.starwin.R;

/**
 * Created by SiKang on 2018/9/19.
 * Loading 弹窗
 */
public class LoadingDialog extends Dialog {
    private ObjectAnimator mRotationAnimation;
    private ObjectAnimator mScaleXAnimation;
    private ObjectAnimator mScaleYAnimation;

    public LoadingDialog(@NonNull Context context) {
        super(context, R.style.style_bg_transparent_dialog);
        View view = LayoutInflater.from(context).inflate(R.layout.base_progress_loading, null, false);

        setContentView(view);
        setCanceledOnTouchOutside(false);
        ImageView rotationView = view.findViewById(R.id.progress_dialog_loadingImv);
        ImageView iconView = view.findViewById(R.id.progress_dialog_iconImv);
        rotationView.setImageResource(LibConfig.LOADING_BACKGROUND);
        iconView.setImageResource(LibConfig.LOADING_ICON);

        mRotationAnimation = ObjectAnimator.ofFloat(rotationView, "rotation", 0, 360);
        mRotationAnimation.setDuration(1500);
        mRotationAnimation.setRepeatCount(Animation.INFINITE);

        mScaleXAnimation = ObjectAnimator.ofFloat(rotationView, "scaleX", 1f, 1.5f, 1f);
        mScaleXAnimation.setDuration(1500);
        mScaleXAnimation.setRepeatCount(Animation.INFINITE);

        mScaleYAnimation = ObjectAnimator.ofFloat(rotationView, "scaleY", 1f, 1.5f, 1f);
        mScaleYAnimation.setDuration(1500);
        mScaleYAnimation.setRepeatCount(Animation.INFINITE);
    }


    @Override
    public void show() {
        super.show();
        mRotationAnimation.start();
        mScaleXAnimation.start();
        mScaleYAnimation.start();
    }

    @Override
    public void dismiss() {
        super.dismiss();
        mRotationAnimation.cancel();
        mScaleXAnimation.cancel();
        mScaleYAnimation.cancel();
    }

}
