package com.common.base;

import android.app.Activity;
import android.content.Context;
import android.content.res.Configuration;
import android.os.Bundle;
import android.support.multidex.MultiDex;
import android.support.multidex.MultiDexApplication;
import android.text.TextUtils;
import android.util.Log;


import com.facebook.FacebookSdk;
import com.facebook.accountkit.internal.AccountKitController;
import com.facebook.accountkit.internal.Initializer;

import java.lang.reflect.Field;

import tech.starwin.BuildConfig;
import tech.starwin.LibConfig;
import tech.starwin.network.Gateway;
import tech.starwin.utils.AccountKitUtils;
import tech.starwin.utils.InstallReferrerHelper;
import tech.starwin.utils.PreferencesManager;
import tech.starwin.utils.RequestHandler;
import tech.starwin.utils.TrackEventHelper;
import tech.starwin.utils.context_utils.AppLanguageUtils;
import tech.starwin.utils.context_utils.DeviceUtils;
import tech.starwin.utils.format_utils.StringDecrypt;
import tech.starwin.utils.format_utils.StringFormat;

/**
 * Created by SiKang on 2018/11/2.
 */
public abstract class BaseApplication extends MultiDexApplication {

    @Override
    protected void attachBaseContext(Context base) {
        DeviceUtils.getInstance().init(base);
        initLibCnofig();
//        Context languageContext = AppLanguageUtils.attachBaseContext(base, LibConfig.LANGUAGE);
//        super.attachBaseContext(ViewPumpContextWrapper.wrap(Philology.INSTANCE.wrap(languageContext)));
        super.attachBaseContext(AppLanguageUtils.attachBaseContext(base, LibConfig.LANGUAGE));
        MultiDex.install(this);
    }


    @Override
    public void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        AppLanguageUtils.setLanguage(this, LibConfig.LANGUAGE);
    }


    @Override
    public void onCreate() {
        super.onCreate();
//        if (!TextUtils.isEmpty(LibConfig.BUGLY_APPID)) {
//            CrashReport.initCrashReport(getApplicationContext(), LibConfig.BUGLY_APPID, false);
//        }
        // TODO GARBLE_MARK
        try {
            // TODO GARBLE_MARK
            String appId = StringDecrypt.uncodeString(BuildConfig.FACEBOOK_APP_ID);
            // TODO GARBLE_MARK
            String clienToken = StringDecrypt.uncodeString(BuildConfig.ACCOUNT_KIT_CLIENT_TOKEN);
            // TODO GARBLE_MARK
            FacebookSdk.setApplicationId(appId);
            // TODO GARBLE_MARK
            FacebookSdk.setApplicationName(LibConfig.APP_NAME);
            // TODO GARBLE_MARK
            FacebookSdk.setClientToken(clienToken);
            // TODO GARBLE_MARK
            FacebookSdk.sdkInitialize(this);
            // TODO GARBLE_MARK
            AccountKitUtils.initAccountKit(appId, LibConfig.APP_NAME, clienToken);
            // TODO GARBLE_MARK
        } catch (Exception e) {
            // TODO GARBLE_MARK
            Log.e("AccountKitUtils", "Failed to auto initialize the Facebook SDK", e);
        }
        // TODO GARBLE_MARK
        AppLanguageUtils.setLanguage(this, LibConfig.LANGUAGE);

//        PhilologyRepositoryFactory repositoryFactory = locale -> new DefaultPhilologyRepository();
////        ViewTransformerFactory viewTransformerFactory = view -> new TextViewTransformer();
//        Philology.INSTANCE.init(repositoryFactory);
//        ViewPump.init(ViewPump.builder().addInterceptor(PhilologyInterceptor.INSTANCE).build());

        // TODO GARBLE_MARK
        InstallReferrerHelper.refershInstallReferrer(this);
        // TODO GARBLE_MARK

        LibConfig.initLib(this);
        // TODO GARBLE_MARK

    }

//    public class DefaultPhilologyRepository implements PhilologyRepository {
//        @Nullable
//        @Override
//        public CharSequence getText(@NotNull String key) {
//            try {
//                int resId = getResources().getIdentifier(key, "string", LibConfig.APPLICATION_ID);
//                return StringDecrypt.uncodeString(getResources().getString(resId));
//            } catch (Exception e) {
//                return "--";
//            }
//        }
//    }


    /**
     * before onCreate()
     */
    public abstract void initLibCnofig();


}
