#!/usr/bin/env bash

cd ../../
basepath=$(cd `dirname $0`; pwd)
project_name=${basepath##*/}
. gradle.properties
cd ../360_jiagu/jiagu

#加固
java -jar jiagu.jar -login 15902141504 qwqw10010
#java -jar jiagu.jar -importsign ../../${project_name}/app/${signing_certificate} ${signging_certificatePassword} ${signing_keyAlias} ${signging_storePassword}
#java -jar jiagu.jar -showsign
java -jar jiagu.jar -config
java -jar jiagu.jar -jiagu ../../${project_name}/resGuardApks/${project_name}_release.apk ../../${project_name}/resGuardApks -autosigns

cd ../../${project_name}
jiagu_apk=""
for file in resGuardApks/*; do
    if [[ ${file} == *jiagu.apk ]]
    then
        jiagu_apk=${file}
    fi
    done

# V1 签名
jarsigner -verbose -digestalg SHA1 -sigalg MD5withRSA \
-keystore app/${signing_certificate} \
-storepass ${signging_storePassword} \
-keypass ${signging_certificatePassword} \
-signedjar resGuardApks/${project_name}_release_jg.apk ${jiagu_apk} \
${signing_keyAlias}

#copy到指定目录
now_time=$(date "+%Y-%m-%d %H_%M_%S")
cp "resGuardApks/${project_name}_release_jg.apk" "/Users/connor/Documents/apks/${project_name}_jg_${now_time}.apk"
