package tech.starwin.mvp.ui.adapter;

import android.content.Context;
import android.support.annotation.DrawableRes;
import android.view.View;

import com.common.bean.ThirdPartItemBean;
import com.common.constants.TDChannel;

import java.nio.channels.Channel;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import tech.starwin.R;
import tech.starwin.base.BaseRecyclerAdapter;
import tech.starwin.base.RecyclerViewHolder;

/**
 * Created by SiKang on 2019/1/28.
 * 同盾认证列表
 */
public class TDAccountAdapter extends BaseRecyclerAdapter<ThirdPartItemBean> {
    private Map<String, TDChannel> iconMap;
    private int normalDrawable = R.drawable.shape_mainsolid_round;
    private int finishDrawable = R.drawable.qmui_icon_notify_done;

    public TDAccountAdapter(Context ctx, List<ThirdPartItemBean> list) {
        super(ctx, list);
        iconMap = new HashMap<>();
        iconMap.put("FACEBOOK", TDChannel.FACEBOOK);
        iconMap.put("GOJEK", TDChannel.GOJEK);
        iconMap.put("GRAB", TDChannel.GRAB);
        iconMap.put("INDOSAT", TDChannel.INDOSAT);
        iconMap.put("LAZADA", TDChannel.LAZADA);
        iconMap.put("NPWP", TDChannel.NPWP);
        iconMap.put("YYS", TDChannel.TELKOMSEL);
        iconMap.put("TOKOPEDIA", TDChannel.TOKOPEDIA);
        iconMap.put("WHATSAPP", TDChannel.WHATSAPP);
        iconMap.put("XL", TDChannel.XL);
    }

    public TDAccountAdapter setBtnDrawable(@DrawableRes int normal, @DrawableRes int done) {
        normalDrawable = normal;
        finishDrawable = done;
        return this;
    }

    @Override
    public Object bindItemLayout() {
        return R.layout.item_td_account;
    }

    @Override
    public void bindData(RecyclerViewHolder holder, int position, ThirdPartItemBean item) {
        if (getChannel(item.getType()) != null) {
            holder.getImageView(R.id.item_tdaccount_logo_imv).setImageResource(getChannel(item.getType()).getIcon());
        }
        holder.getTextView(R.id.item_tdaccount_name_tv).setText(item.getType());
        holder.getImageView(R.id.item_tdaccount_finish_imv).setImageResource(finishDrawable);
//        holder.getView(R.id.item_tdaccount_start_btn).setBackgroundResource(normalDrawable);

        if (item.isBindFlag()) {
            holder.getImageView(R.id.item_tdaccount_finish_imv).setVisibility(View.VISIBLE);
            holder.getView(R.id.item_tdaccount_start_btn).setVisibility(View.GONE);
        } else {
            holder.getImageView(R.id.item_tdaccount_finish_imv).setVisibility(View.GONE);
            holder.getView(R.id.item_tdaccount_start_btn).setVisibility(item.isForceFlag() ? View.GONE : View.VISIBLE);
        }

    }

    public TDChannel getChannel(String channelName) {
        if (iconMap != null && iconMap.containsKey(channelName)) {
            return iconMap.get(channelName);
        } else {
            return null;
        }
    }

    /**
     * 是否完成了必须的认证
     */
    public static boolean isTDPassed(List<ThirdPartItemBean> itemBeans) {
        for (ThirdPartItemBean item : itemBeans) {
            if (!item.isBindFlag() && item.isForceFlag()) {
                return false;
            }
        }
        return true;
    }

}
