import json
from tools.garble.activity_garble import ActivityGarble
from tools.garble.api_garble import ApiGarble
from tools.garble.manifest_grable import ManifestGarble
from tools.garble.package_garble import PackageGarble
from tools.garble.string_garble import StringGarble
from tools.garble.img_garble import ImageGarble
from tools.garble.java_garble import JavaGarble
from tools.garble.layout_garble import LayoutGarble
from func import Function
import os

#读取config.json配置
config_json = {}
with open("config.json", "r", encoding="utf-8") as fin:
    config_json = json.loads(fin.read())

#加入properties配置
properties = Function().load_properties("%s/gradle.properties"%config_json['root'])
config = config_json.copy()
config.update(properties)

print(" ")
print("------------- 使用帮助（混淆完一定要全流程测试） -----------------")
print("0、一条龙混淆")
print("1、activity类名混淆（支持kotlin，没测试过）")
print("2、api混淆（针对 Retrofit 注解）")
print("3、manifest混淆 在包路径中随机插入Activity并注册")
print("4、包路径混淆（支持kotlin，没测试过）")
print("5、字符串插入/加密")
print("6、图片混淆（修改md5 & 创建随机图片，体积会增加1-2M）")
print("7、java文件插入乱码（慎用，必须全流程测试）")
print("8、layout 混淆")
print("21、还原代码")
print(" ")

command = int(input("请输入指令编号："))

if command == 0:
    #布局文件混淆 必须放前面
    LayoutGarble().layout_garble(config)
    #Manifest混淆
    ManifestGarble().manifest_garble(config)
    #插入java乱码 必须放前面
    JavaGarble().java_garble(config)
    #四大组件类名混淆
    ActivityGarble().activity_garble(config)
    #包路径混淆
    PackageGarble().pkg_garble(config)
     #Api混淆
    ApiGarble().api_garble(config)
    #字符串混淆
    StringGarble().str_grable(config)
    #图片混淆
    ImageGarble().img_garble(config)

elif command == 1:
    #配置参数 config.json - activities
    ActivityGarble().activity_garble(config)

elif command == 2:
    ApiGarble().api_garble(config)

elif command == 3:
    #注意： src/main/java 目录下，只能是目录，不可以有文件
    # 如果使用了 cash_plugin_toolbox ，需要更新一下，确保 Manifest 中有 <application> 标签
    ManifestGarble().manifest_garble(config)

elif command == 4:
    #所有library  src/main/java 下的包名混淆
    PackageGarble().pkg_garble(config)

elif command == 5:
    StringGarble().str_grable(config)

elif command == 6:
    ImageGarble().img_garble(config)

elif command == 7:
    JavaGarble().java_garble(config)

elif command == 8:
    LayoutGarble().layout_garble(config)

elif command == 21:
    #每行一个shell命令，参考自行修改
    command = "%s\n%s\n%s\n%s\n%s\n%s\n%s\n%s\n%s\n" \
            % (
                "cd %s" % config['root'],
                "git checkout . && git clean -df",
                "git reset --hard origin/%s" % config['git_branch'],
                "cd lib_base || { echo \"lib_base not exist!\"; exit 1; }",
                "git checkout . && git clean -df",
                "git reset --hard origin/master",
                "cd ../cash_plugin_toolbox",
                "git checkout . && git clean -df",
                "git reset --hard origin/master"
            )
    os.system(command)

