/*
 * Decompiled with CFR 0.152.
 */
package com.meituan.android.walle;

import com.meituan.android.walle.ApkUtil;
import com.meituan.android.walle.SignatureNotFoundException;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.Arrays;
import java.util.Map;

public final class PayloadReader {
    private PayloadReader() {
    }

    public static String getString(File apkFile, int id) {
        byte[] bytes = PayloadReader.get(apkFile, id);
        if (bytes == null) {
            return null;
        }
        try {
            return new String(bytes, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static byte[] get(File apkFile, int id) {
        Map<Integer, ByteBuffer> idValues = PayloadReader.getAll(apkFile);
        if (idValues == null) {
            return null;
        }
        ByteBuffer byteBuffer = idValues.get(id);
        if (byteBuffer == null) {
            return null;
        }
        return PayloadReader.getBytes(byteBuffer);
    }

    private static byte[] getBytes(ByteBuffer byteBuffer) {
        byte[] array = byteBuffer.array();
        int arrayOffset = byteBuffer.arrayOffset();
        return Arrays.copyOfRange(array, arrayOffset + byteBuffer.position(), arrayOffset + byteBuffer.limit());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<Integer, ByteBuffer> getAll(File apkFile) {
        Map<Integer, ByteBuffer> idValues = null;
        try {
            RandomAccessFile randomAccessFile = null;
            AbstractInterruptibleChannel fileChannel = null;
            try {
                randomAccessFile = new RandomAccessFile(apkFile, "r");
                fileChannel = randomAccessFile.getChannel();
                ByteBuffer apkSigningBlock2 = ApkUtil.findApkSigningBlock((FileChannel)fileChannel).getFirst();
                idValues = ApkUtil.findIdValues(apkSigningBlock2);
            }
            catch (IOException iOException) {
            }
            finally {
                try {
                    if (fileChannel != null) {
                        fileChannel.close();
                    }
                }
                catch (IOException iOException) {}
                try {
                    if (randomAccessFile != null) {
                        randomAccessFile.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
        catch (SignatureNotFoundException signatureNotFoundException) {
            // empty catch block
        }
        return idValues;
    }
}

