package com.common.activity;

import android.content.Context;
import android.text.TextUtils;
import android.webkit.WebChromeClient;
import android.webkit.WebSettings;
import android.webkit.WebView;

import com.common.base.BaseActivity;
import com.common.bean.EventCenterBean;
import com.scwang.smartrefresh.layout.SmartRefreshLayout;

import tech.starwin.R;
import tech.starwin.mvp.presenter.UserPresenter;
import tech.starwin.utils.context_utils.ActivityJumper;

/**
 * Created by SiKang on 2018/11/19.
 */
public class WebActivity extends BaseActivity {
    public static void start(Context context, String title, String url) {
        new ActivityJumper.Builder(context, WebActivity.class)
                .put("title", title)
                .put("url", url)
                .build().start();
    }

    public static void startContract(Context context, String title, String contractNo, String companyName) {
        new ActivityJumper.Builder(context, WebActivity.class)
                .put("title", title)
                .put("url", "contract")
                .put("companyName", companyName)
                .put("contractNo", contractNo)
                .build().start();
    }


    SmartRefreshLayout refreshLayout;
    WebView webView;


    @Override
    public int bindLayout() {
        return R.layout.activity_web;
    }

    @Override
    public void initView() {
        String url = getIntent().getStringExtra("url");
        String title = getIntent().getStringExtra("title");

        setTopBarTitle(title);
        refreshLayout = findViewById(R.id.activity_web_refresh);
        webView = findViewById(R.id.activity_web_wv);
        WebSettings setting = webView.getSettings();
        setting.setJavaScriptEnabled(true);//设置webview支持javascript脚本
        setting.setCacheMode(WebSettings.LOAD_NO_CACHE);//不加载缓存
        setting.setDomStorageEnabled(false);
        setting.setDatabaseEnabled(false);
        setting.setAppCacheEnabled(false);
        setting.setBlockNetworkImage(true);

        webView.setWebChromeClient(new WebChromeClient() {
            @Override
            public void onProgressChanged(WebView view, int newProgress) {
                if (newProgress == 100) {
                    refreshLayout.finishRefresh();
                }
            }
        });

        refreshLayout.setEnableLoadMore(false);

        refreshLayout.setOnRefreshListener(refreshLayout -> {
            if ("contract".equals(url)) {
                getPresenter(UserPresenter.class).getContract("getContract", getIntent().getStringExtra("contractNo"));
            } else {
                if (TextUtils.isEmpty(webView.getUrl())) {
                    webView.loadUrl(url);
                } else {
                    webView.reload();
                }
            }
        });

    }

    @Override
    protected void onStart() {
        super.onStart();
        if ("contract".equals(getIntent().getStringExtra("url"))) {
            getPresenter(UserPresenter.class).getContract("getContract", getIntent().getStringExtra("contractNo"));
        } else {
            refreshLayout.autoRefresh();
        }
    }

    @Override
    public void onHttpSuccess(String action, Object result) {
        if ("getContract".equals(action)) {
            refreshLayout.finishRefresh();
            EventCenterBean contactBean = (EventCenterBean) result;
            String html = contactBean.getContent().replace("${companyName}", getIntent().getStringExtra("companyName"));
            webView.loadDataWithBaseURL(null, html, "text/html", "utf-8", null);
        }
    }
}
