import json
from tools.garble.activity_garble import ActivityGarble
from tools.garble.api_garble import ApiGarble
from tools.garble.manifest_grable import ManifestGarble
from tools.garble.package_garble import PackageGarble
from tools.garble.string_garble import StringGarble
from func import Function
import os

#读取config.json配置
config_json = {}
with open("config.json", "r", encoding="utf-8") as fin:
    config_json = json.loads(fin.read())

#加入properties配置
properties = Function().load_properties(config_json['properties'])
config = config_json.copy()
config.update(properties)

print(" ")
print("使用帮助")
print("1、activity类名混淆")
print("2、api混淆（针对 Retrofit 注解）")
print("3、manifest混淆 在包路径中随机插入Activity并注册")
print("4、包路径混淆")
print("5、字符串插入/加密")
print("6、还原代码")
print(" ")

command = int(input("请输入指令编号："))

if command == 1:
    #配置参数 config.json - activities
    ActivityGarble().activity_garble(config)

elif command == 2:
    ApiGarble().api_garble(config)

elif command == 3:
    #注意： src/main/java 目录下，只能是目录，不可以有文件
    # 如果使用了 cash_plugin_toolbox ，需要更新一下，确保 Manifest 中有 <application> 标签
    ManifestGarble().manifest_garble(config)

elif command == 4:
    #所有library  src/main/java 下的包名混淆
    PackageGarble().pkg_garble(config)

elif command == 5:
    StringGarble().str_grable(config)

elif command == 6:
    #每行一个shell命令，参考自行修改
    command = "%s\n%s\n%s\n%s\n%s\n%s\n%s\n%s\n%s\n" \
            % (
                "cd %s" % config['root'],
                "git checkout . && git clean -df",
                "git reset --hard origin/%s" % config['git_branch'],
                "cd lib_base || { echo \"lib_base not exist!\"; exit 1; }",
                "git checkout . && git clean -df",
                "git reset --hard origin/master",
                "cd ../cash_plugin_toolbox",
                "git checkout . && git clean -df",
                "git reset --hard origin/master"
            )
    os.system(command)

