package tech.starwin.widget;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.ViewGroup;
import android.widget.FrameLayout;


/**
 * Created by SiKang on 2018/11/15.
 * 首页UI的布局设计中，页面内容的尺寸是大于DrawerLayout的，所以无法将Content放在DrawerLayout中，只能将Drawer覆盖在Content上，而这样又会导致Touch事件冲突，Content无法收到Touch事件
 * 所以使用了PenetrateDrawerLayout来放行Touch事件，放行后导致新的问题，即 DOWN 事件被Content消费后，PenetrateDrawerLayout无法收到后续的 MOVE 事件，Drawer就无法实现手动滑出
 * 这里的 PenetrateFrameLayout 通过 setPartnerGroup() 方法绑定 PenetrateDrawerLayout ,将 MOVE 事件重新交给 PenetrateDrawerLayout 处理
 */
public class PenetrateFrameLayout extends FrameLayout {
    ViewGroup partnerGroup;

    public PenetrateFrameLayout(@NonNull Context context) {
        super(context);
    }

    public PenetrateFrameLayout(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
    }

    public PenetrateFrameLayout(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    public void setPartnerGroup(ViewGroup partnerGroup) {
        this.partnerGroup = partnerGroup;
    }

    @Override
    public boolean dispatchTouchEvent(MotionEvent ev) {
//        switch (ev.getAction()) {
//            case MotionEvent.ACTION_DOWN:
//                LogUtils.d("TouchTest", "Frame: ACTION_DOWN" + isClickable());
//                break;
//            case MotionEvent.ACTION_MOVE:
//                LogUtils.d("TouchTest", "Frame: ACTION_MOVE" + isClickable());
//                break;
//            case MotionEvent.ACTION_CANCEL:
//                LogUtils.d("TouchTest", "Frame: ACTION_CANCEL" + isClickable());
//                break;
//            case MotionEvent.ACTION_UP:
//                LogUtils.d("TouchTest", "Frame: ACTION_UP" + isClickable());
//                break;
//        }
        if (partnerGroup != null ) {
            partnerGroup.dispatchTouchEvent(ev);
        }
        if (isClickable()) {
            super.dispatchTouchEvent(ev);
        }
        return true;
//        return isClickable() ? super.dispatchTouchEvent(ev) : true;
    }



    @Override
    public boolean onTouchEvent(MotionEvent ev) {
        super.onTouchEvent(ev);
        return false;
    }

    @Override
    protected void onDetachedFromWindow() {
        partnerGroup = null;
        super.onDetachedFromWindow();
    }
}
