package tech.starwin.utils.context_utils;

import android.Manifest;
import android.annotation.SuppressLint;
import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.provider.Settings;
import android.support.v4.app.ActivityCompat;
import android.telephony.TelephonyManager;
import android.text.TextUtils;

import java.io.File;
import java.util.UUID;

import tech.starwin.utils.LogUtils;
import tech.starwin.utils.PreferencesManager;

/**
 * Created by SiKang on 2018/12/10.
 */
public class AppInfoUtils {

    /**
     * 获取应用程序名称
     */
    public static synchronized String getAppName(Context context) {
        try {
            PackageManager packageManager = context.getPackageManager();
            PackageInfo packageInfo = packageManager.getPackageInfo(context.getPackageName(), 0);
            int labelRes = packageInfo.applicationInfo.labelRes;
            return context.getResources().getString(labelRes);
        } catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    /**
     * 获取AndroidID
     */
    public static String getAndroidID(Context context) {
        String android_id = Settings.Secure.getString(context.getContentResolver(), Settings.Secure.ANDROID_ID);
        if (TextUtils.isEmpty(android_id)) {
            android_id = PreferencesManager.get().getDeviceUUID();
            if (TextUtils.isEmpty(android_id)) {
                android_id = UUID.randomUUID().toString();
                PreferencesManager.get().saveDeviceUUID(android_id);
            }
        }
        return android_id;
    }


    /**
     * 判断是否存在某个包且可获取入口
     */
    public static boolean isPackageExist(Context context, String packageName) {
        if (packageName == null || TextUtils.isEmpty(packageName)) {
            return false;
        }
        if (context != null) {
            try {
                if (!(TextUtils.isEmpty(packageName) || context.getPackageManager().getLaunchIntentForPackage(packageName) == null)) {
                    return true;
                }
            } catch (Exception unused) {
                return false;
            }
        }
        return false;
    }


    @SuppressLint("MissingPermission")
    public static String getPhoneNumber(Context context) {
        try {
            TelephonyManager telephonyManager = (TelephonyManager) context.getSystemService(Context.TELEPHONY_SERVICE);
            if (telephonyManager != null && PermissionsHelper.isGranted(context, Manifest.permission.READ_PHONE_STATE)) {
                return telephonyManager.getLine1Number();
            }
        } catch (Exception e) {
            return "";
        }
        return "";
    }

    @SuppressLint("MissingPermission")
    public static String getIMSI(Context context) {
        try {
            TelephonyManager telephonyManager = (TelephonyManager) context.getSystemService(Context.TELEPHONY_SERVICE);
            if (telephonyManager != null && PermissionsHelper.isGranted(context, Manifest.permission.READ_PHONE_STATE)) {
                String imsi = telephonyManager.getSubscriberId();
                LogUtils.d("IMSI_INFO",imsi);
                return imsi;
            }
        } catch (Exception e) {
            return "";
        }
        return "";
    }


    @SuppressLint("MissingPermission")
    public static String getSimSerialNumber(Context context) {
        try {
            TelephonyManager telephonyManager = (TelephonyManager) context.getSystemService(Context.TELEPHONY_SERVICE);
            if (telephonyManager != null && PermissionsHelper.isGranted(context, Manifest.permission.READ_PHONE_STATE)) {
                return telephonyManager.getSimSerialNumber();
            }
        } catch (Exception e) {
            return "";
        }
        return "";
    }

    /**
     * 判断是否已ROOT
     */
    public static boolean isRoot() {
        try {
            return new File("/system/bin/su").exists() || new File("/system/xbin/su").exists();
        } catch (Exception e) {
            return false;
        }
    }


}
