package tech.starwin.utils.ui_utils;

import android.animation.ObjectAnimator;
import android.animation.ValueAnimator;
import android.view.View;

/**
 * Created by SiKang on 2018/10/22.
 */
public class AnimatorGenerator {
    public static final String ANIM_SCALE_X="scaleX";
    public static final String ANIM_SCALE_Y="scaleY";
    public static final String ANIM_ROTATION="rotation";
    public static final String ANIM_TRANSLATION_X="translationX";
    public static final String ANIM_TRANSLATION_Y="translationY";
    public static final String ANIM_ALPHA="alpha";


    public static ObjectAnimator createScaleXAnimator(View view, long duration, float... values) {
        ObjectAnimator animator = ObjectAnimator.ofFloat(view, "scaleX", values);
        animator.setDuration(duration);
        return animator;
    }

    public static ObjectAnimator createScaleYAnimator(View view, long duration, float... values) {
        ObjectAnimator animator = ObjectAnimator.ofFloat(view, "scaleY", values);
        animator.setDuration(duration);
        return animator;
    }

    public static ObjectAnimator createRotationAnimator(View view, long duration, float... values) {
        ObjectAnimator animator = ObjectAnimator.ofFloat(view, "rotation", values);
        animator.setDuration(duration);
        return animator;
    }

    public static ObjectAnimator createTranslationXnAnimator(View view, long duration, float... values) {
        ObjectAnimator animator = ObjectAnimator.ofFloat(view, "translationX", values);
        animator.setDuration(duration);
        return animator;
    }

    public static ObjectAnimator createTranslationYAnimator(View view, long duration, float... values) {
        ObjectAnimator animator = ObjectAnimator.ofFloat(view, "translationY", values);
        animator.setDuration(duration);
        return animator;
    }

    /**
     * 开关动画
     * 将打开动画参数取反序作为还原动作
     */
    public static class SwitchAnimatorAdapter {
        ObjectAnimator openAnimator;
        ObjectAnimator closeAnimator;

        public SwitchAnimatorAdapter(View view, String propertyName, float... values) {
            openAnimator = ObjectAnimator.ofFloat(view, propertyName, values);
            int length = values.length;
            float[] closeValues = new float[length];
            for (int i = 0; i < length; i++) {
                closeValues[length - 1 - i] = values[i];
            }
            closeAnimator = ObjectAnimator.ofFloat(view, propertyName, closeValues);
        }

        public void setDuration(long duration) {
            openAnimator.setDuration(duration);
            closeAnimator.setDuration(duration);
        }

        public void addUpdateListener(ValueAnimator.AnimatorUpdateListener listener) {
            openAnimator.addUpdateListener(listener);
            closeAnimator.addUpdateListener(listener);
        }

        public void start() {
            openAnimator.start();
        }

        public void revert() {
            closeAnimator.start();
        }

    }


}