package tech.starwin.mvp.api;

import android.support.annotation.NonNull;

import java.util.ArrayList;
import java.util.List;

import io.reactivex.Observable;
import okhttp3.ResponseBody;
import retrofit2.http.Field;
import retrofit2.http.FormUrlEncoded;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.POST;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.Query;

import com.common.bean.BankBean;
import com.common.bean.DepositMethodsBean;
import com.common.bean.DepositResponseBean;
import com.common.bean.HarvestGrantBean;
import com.common.bean.HistoryLoanAppInfoBean;
import com.common.bean.LatestLoanAppBean;
import com.common.bean.LoanRange;
import com.common.bean.LoaningAmoutBean;
import com.common.bean.ProductBean;
import com.common.bean.ProgressBean;
import com.common.bean.ResponseErrorBody;

/**
 * Created by SiKang on 2018/9/20.
 * 和贷款业务相关的 API
 */
public interface LoanApi {
    /**
     * 获取贷款额度、期限 范围
     */
    @GET("loanapp/range")
    Observable<LoanRange> getLoanRange();

    /**
     * 验证贷款资格
     */
    @GET("loanapp/qualification")
    Observable<ResponseErrorBody> isQualification(@Header("X-AUTH-TOKEN") String token);

    /**
     * 贷款进度
     */
    @GET("record/progress")
    Observable<ProgressBean> getCertifyProgress(@Header("X-AUTH-TOKEN") String token,
                                                @Query("thirdpartyDataFlag") boolean thirdpartyDataFlag);

    /**
     * 获取商品列表
     */
    @GET("loanapp/product_default")
    Observable<List<ProductBean>> getProductsDefault();

    @GET("loanapp/product")
    Observable<List<ProductBean>> getProducts();

    /**
     * 获取最新的贷款申请信息
     */
    @GET("loanapp/latest/v2")
    Observable<LatestLoanAppBean> getLatestLoanApp(@Header("X-AUTH-TOKEN") String token);

    /**
     * 取消贷款
     */
    @FormUrlEncoded
    @POST("loanapp/cancel")
    Observable<ResponseBody> cancelLoan(@Field("loanAppId") String loanAppId,
                                        @Header("X-AUTH-TOKEN") String token);

    /**
     * 贷款详情
     */
    @GET("loanapp/repayment-amount-detail")
    Observable<LoaningAmoutBean> getLoanAmoutData(@Query("principal") double amount,
                                                  @Query("period") int day,
                                                  @Query("periodUnit") String periodUnit,
                                                  @Query("productId") long productId);

    /**
     * 我的贷款记录
     */
    @GET("loanapp/all/v2")
    Observable<List<HistoryLoanAppInfoBean>> getLoanAppAll(@Header("X-AUTH-TOKEN") String token);


    /**
     * 获取付款方式
     */
    @GET("loanapp/deposit/methods")
    Observable<DepositMethodsBean> getDepostMethods(@Header("X-AUTH-TOKEN") String token);


    /**
     * 还款
     *
     * @param loanAppId 贷款订单id
     * @param method    还款方式
     * @param amout     还款金额
     */
    @POST("loanapp/deposit")
    Observable<DepositResponseBean> getRepayOrder(@Query("loanAppId") String loanAppId,
                                                  @Query("currency") String currency,
                                                  @Query("depositMethod") String method,
                                                  @Query("amount") double amout,
                                                  @Header("X-AUTH-TOKEN") String token
    );


    /**
     * 是否授权数据
     */
    @GET("record/harvest-grant-status")
    Observable<HarvestGrantBean> getHarvestGrant(@Header("X-AUTH-TOKEN") String token);


    /**
     * 银行列表
     */
    @GET("bank/support")
    Observable<List<BankBean>> getBankList();


    /**
     * 申请贷款，提交银行卡
     */
    @PUT("loanapp/{loanAppId}/bank")//API-REPAIR*-*loanapp/bank/{loanAppId}
    Observable<ResponseBody> addBank(@Path("loanAppId") String loanAppId, @Query("bankCode") @NonNull String bankCode, @Query("cardNo") String cardNo,
                                     @Query("applyFor") String applyFor, @Query("applyChannel") @NonNull String applyChannel, @Query("applyPlatform") String android,
                                     @Query("couponId") long couponId, @Header("X-AUTH-TOKEN") String token);


}
