#!/usr/bin/env python3
import json
import string
import random
import glob, os
import sys


def new_func_code():
    code = "\t@Override\n" + \
           "\tpublic void onLivenessSuccess(OliveappFaceInfo oliveappFaceInfo) {\n" + \
           "\t\tLivenessDetectionFrames pkg = this.getLivenessDetectionPackage();\n" + \
           "\t\tif ((pkg != null ? pkg.verificationData : null) == null) {\n" + \
           "\t\t\tfinishForResult(false, getResources().getString(R.string.faceid_detect_fail));\n" + \
           "\t\t} else {\n" + \
           "\t\t\tPreferencesManager.get().saveVerificationData(pkg.verificationData);\n" + \
           "\t\t\tfinishForResult(true, "");\n" + \
           "\t\t}\n" + \
           "\t}\n"
    return code

def add_func(path):
    # print("processing content: %s..." % path)
    with open(path, "r", encoding="utf-8") as f:
        # readlines以列表的形式将文件读出
        lines = f.readlines()

    with open(path, "w", encoding="utf-8") as f_w:
        for line in lines:
            if "FaceDetectActivity extends LivenessDetectionMainActivity" in line:
                line = line + "\n" + new_func_code() + "\n"
            f_w.write(line)
    return


for root, dirs, files in os.walk("../../../app/src/main"):
    directory = os.path.join(os.getcwd(), root)
    for file in files:
        if file.endswith("FaceDetectActivity.java"):
            # get the path of the java file
            path = os.path.join(directory, file)
            add_func(path)