package tech.starwin.widget;

import android.annotation.SuppressLint;
import android.app.Dialog;
import android.content.Context;
import android.support.annotation.NonNull;

import com.qmuiteam.qmui.widget.dialog.QMUITipDialog;

import tech.starwin.LibConfig;
import tech.starwin.utils.ui_utils.DialogFactory;


/**
 * Created by SiKang on 2018/9/19.
 * 请求进度Dialog，用于展示Loading 或 错误信息
 */
public class ProgressDialog {
    //loading dialog
    private boolean enable = true;
    private Dialog loadingDialog;
    private Context context;

    public ProgressDialog(@NonNull Context context) {
        this.context = context;
        //如果配置了icon，使用icon加载动画，否则用默认动画
        if (LibConfig.LOADING_ICON != 0) {
            this.loadingDialog = new LoadingDialog(context);
        } else {
            this.loadingDialog = DialogFactory.createTipDialog(context, QMUITipDialog.Builder.ICON_TYPE_LOADING, "Loading");
        }
    }

    public ProgressDialog(@NonNull Dialog loadingDialog) {
        this.context = loadingDialog.getContext();
        this.loadingDialog = loadingDialog;
    }


    public boolean isShowing() {
        return loadingDialog.isShowing();
    }


    public void showLoading() {
        if (!loadingDialog.isShowing() && enable) {
            loadingDialog.show();
        }
    }

    public void dissmissLoading() {
        if (loadingDialog.isShowing()) {
            loadingDialog.dismiss();
        }
    }

    /**
     * 关闭loading 显示错误提示
     */
    @SuppressLint("CheckResult")
    public void showError(String msg) {
        final Dialog errorDialog = DialogFactory.createTipDialog(context, QMUITipDialog.Builder.ICON_TYPE_FAIL, msg);
        if (loadingDialog.isShowing())
            loadingDialog.dismiss();
        DialogFactory.showTiming(errorDialog, 1500);
    }

    public void setEnable(boolean enable) {
        this.enable = enable;
    }
}
