package tech.starwin.mvp.ui.adapter;

import android.content.Context;
import android.widget.TextView;

import java.util.List;

import tech.starwin.LibConfig;
import tech.starwin.R;
import tech.starwin.base.BaseRecyclerAdapter;
import tech.starwin.base.RecyclerViewHolder;
import com.common.bean.MsgInboxBean;
import tech.starwin.utils.format_utils.StringFormat;
import tech.starwin.utils.ui_utils.UIHelper;

/**
 * Created by SiKang on 2018/11/20.
 */
public class MessageAdapter extends BaseRecyclerAdapter<MsgInboxBean> {
    public MessageAdapter(Context ctx, List<MsgInboxBean> list) {
        super(ctx, list);
    }

    @Override
    public Object bindItemLayout() {
        return R.layout.item_message_list;
    }

    @Override
    public void bindData(RecyclerViewHolder holder, int position, MsgInboxBean item) {
        String time = StringFormat.convertTime(item.getCreateTime(), "yyyy-MM-dd HH:mm:ss");
        holder.getTextView(R.id.item_messageList_title_tv).setText(time);

        TextView detailTv = holder.getTextView(R.id.item_messageList_detail_tv);
        if (item.isRead()) {
            String text_readed = getContext().getString(R.string.text_readed);
            UIHelper.setTextHighLight(detailTv, item.getMsgBody() + " " + text_readed, R.color.qmui_config_color_gray_6, text_readed);
        } else {
            String text_new = getContext().getString(R.string.text_new);
            UIHelper.setTextHighLight(detailTv, item.getMsgBody() + " " + text_new, LibConfig.MAIN_COLOR, text_new);
        }

    }
}
