package tech.starwin.utils;

import java.util.HashMap;
import java.util.Map;

/**
 * Created by SiKang on 2018/9/14.
 */
public class Params {
    private Map<String, Object> params;

    private Params(Map params) {
        this.params = params;
    }

    public Map<String, Object> params() {
        return params;
    }


    public static class Builder {
        private Map<String, Object> params;

        public Builder() {
            params = new HashMap<>();
        }

        public Builder put(String key, Object value) {
            params.put(key, value);
            return this;
        }

        public Params build() {
            return new Params(params);
        }
    }
}
