package com.common.widget;

import android.content.Context;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;

import com.qmuiteam.qmui.widget.QMUITopBar;

/**
 * Created by SiKang on 2018/11/18.
 */
public class TopBar extends LinearLayout {
    private View statusBar;
    private QMUITopBar toolBar;
    private int statusBarHeight = 0;
    LayoutParams statusBarLayout;
    LayoutParams toolBarLayout;

    public TopBar(Context context) {
        super(context);
        init(context);
    }

    public TopBar(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        init(context);
    }

    public TopBar(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        init(context);
    }

    private void init(Context context) {
        setOrientation(VERTICAL);
        statusBar = new View(context);
        statusBarLayout = new LayoutParams(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.WRAP_CONTENT);
        statusBar.setLayoutParams(statusBarLayout);

        toolBar = new QMUITopBar(context);
        toolBarLayout = new LayoutParams(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.WRAP_CONTENT);
        toolBar.setLayoutParams(toolBarLayout);

        addView(statusBar);
        addView(toolBar);
    }

    @Override
    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int heightMode = MeasureSpec.getMode(heightMeasureSpec);
        int heightSize = MeasureSpec.getSize(heightMeasureSpec);
        heightMeasureSpec = MeasureSpec.makeMeasureSpec(heightSize + statusBarHeight, heightMode);

        statusBarLayout.height = statusBarHeight;
        toolBarLayout.height = heightSize;

        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
    }

    public QMUITopBar toolBar() {
        return toolBar;
    }

    public void setStatusBarHeight(int statusBarHeight) {
        this.statusBarHeight = statusBarHeight;
        invalidate();
    }
}
