package tech.starwin.utils;

import android.content.Context;
import android.os.Bundle;
import android.text.TextUtils;
import android.view.View;
import android.widget.Button;
import android.widget.TextView;


import tech.starwin.utils.tracker.TrackEvent;
import tech.starwin.utils.tracker.TrackUtils;

import tech.starwin.LibConfig;
import tech.starwin.mvp.presenter.UserPresenter;


/**
 * Created by SiKang on 2018/10/11.
 * FireBase 功能辅助类
 */
public class TrackEventHelper {
    private static final String TAG = "TrackEvent";
    public static final String REST_URL = "rest_url";
    private static UserPresenter userPresenter = new UserPresenter();

    /**
     * click埋点，CONTENT_TYPE = view.getTag()
     */
    public static void LogClickEventByTag(View view) {
        if (view.getTag() != null && view.getTag() instanceof String) {
            TrackEvent.Event event = TrackUtils.findEventByTag((String) view.getTag());
            if (event != null) {
                logEvent(event);
            }
        }
    }

    /**
     * click埋点 CONTENT_TYPE = view.getText()
     */
    public static void LogClickEventByText(View view) {
        String itemName = "";
        if (view instanceof TextView) {
            itemName = ((TextView) view).getText().toString();
        } else if (view instanceof Button) {
            itemName = ((Button) view).getText().toString();
        }
        if (!TextUtils.isEmpty(itemName)) {
            logClickEventByName(view.getContext(), itemName);
        }
    }

    /**
     * click埋点
     */
    public static void logClickEventByName(Context context, String itemName) {
        Bundle bundle = new Bundle();
        String eventName = "click_" + itemName;
//        bundle.putString(FirebaseAnalytics.Param.CONTENT_TYPE, eventName);
        //FireBase 埋点
//        FirebaseAnalytics.getInstance(context).logEvent(FirebaseAnalytics.Event.SELECT_CONTENT, bundle);
    }


    /**
     * 行为埋点
     */
    public static void logEvent(String eventName) {
        //FireBase 埋点
//        FirebaseAnalytics.getInstance(LibConfig.getActivity()).logEvent(eventName, null);
        LogUtils.d(TAG, "system - api - " + eventName);
        userPresenter.trackEvent(eventName);
    }

    /**
     * 行为埋点
     */
    public static void logEvent(TrackEvent.Event event) {
        LogUtils.d(TAG, event.type() + " " + event.action() + " " + event.value());
        userPresenter.trackEvent(event.type(), event.action(), event.value());
    }

    /**
     * 获取FireBase RemoteConfig 并激活
     */
    private static final int CACHE_EXPIRATION_SECONDS = 60 * 5;//remoteConfig 刷新频率


    public interface OnTrackEventListener {
        void onActionEvent(String eventName);

        void onActionClick(String eventName);
    }

//    public static void fetchRemoteConfig() {
//        final FirebaseRemoteConfig config = FirebaseRemoteConfig.getInstance();
//        config.fetch(CACHE_EXPIRATION_SECONDS)
//                .addOnCompleteListener(new OnCompleteListener<Void>() {
//                    @Override
//                    public void onComplete(@NonNull Task<Void> task) {
//                        if (task.isSuccessful()) {
//                            config.activateFetched();
//                        }
//                    }
//                });
//    }

}
