#!/usr/bin/env python3
import os
import sys
import random
from PIL import Image,ImageDraw,ImageFont
def add_text_to_image(image, text):
    #水印字体随机大小
    font_size = random.randint(30,60)
    font = ImageFont.truetype('Arial.ttf', font_size)
    
    # 添加背景
    new_img = Image.new('RGBA', (image.size[0] * 3, image.size[1] * 3), (0, 0, 0, 0))
    new_img.paste(image, image.size)
    
    # 添加水印
    font_len = len(text)
    rgba_image = new_img.convert('RGBA')
    text_overlay = Image.new('RGBA', rgba_image.size, (255, 255, 255, 0))
    image_draw = ImageDraw.Draw(text_overlay)
    
    #随机位置
    for i in range(random.randint(0,100), rgba_image.size[0], font_len*font_size + font_size*2):
        for j in range(random.randint(0,100), rgba_image.size[1], font_size*5):
            image_draw.text((i, j), text, font=font, fill=(0, 0, 0, 50))
    text_overlay = text_overlay.rotate(-45)
    image_with_text = Image.alpha_composite(rgba_image, text_overlay)

    # 裁切图片
    image_with_text = image_with_text.crop((image.size[0], image.size[1], image.size[0] * 2, image.size[1] * 2))
    return image_with_text

if __name__ == '__main__':
    img = Image.open(sys.argv[1])
    im_after = add_text_to_image(img, sys.argv[2])
    output = sys.argv[1].split(".");
    output = output[0] + "_mark" + "." + output[1]
    print(output)
    im_after.save(output)
