package tech.starwin.utils;

import android.text.TextUtils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Created by SiKang on 2018/10/17.
 */
public class StringAdapter {
    List<Item> itemList = new ArrayList<>();

    public void addItem(Item item) {
        itemList.add(item);
    }

    public String getItemValue(String info) {
        if (!TextUtils.isEmpty(info)) {
            for (Item item : itemList) {
                if (info.equals(item.infoStr))
                    return item.dataStr;
            }
        }
        return "";
    }

    public String getItemInfoStr(String value) {
        if (!TextUtils.isEmpty(value)) {
            for (Item item : itemList) {
                if (value.equals(item.dataStr))
                    return item.infoStr;
            }
        }
        return "";
    }

    public String[] getInfoArray() {
        String[] itemArray = new String[itemList.size()];
        for (int i = 0; i < itemList.size(); i++) {
            itemArray[i] = itemList.get(i).infoStr;
        }
        return itemArray;
    }

    public static class Item {
        //需要翻译后 展示给用户的文本
        public String infoStr;
        //需要传给服务器的文本
        public String dataStr;

        public Item(String value, String infoStr) {
            this.infoStr = infoStr;
            this.dataStr = value;
        }

    }
}
