package tech.starwin.mvp.api;


import android.support.annotation.NonNull;

import java.util.ArrayList;
import java.util.List;

import io.reactivex.Observable;
import okhttp3.ResponseBody;
import retrofit2.http.Body;
import retrofit2.http.Field;
import retrofit2.http.FormUrlEncoded;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.POST;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.Url;

import com.common.bean.ActivityInfoBean;
import com.common.bean.BannerMessageDto;
import com.common.bean.BasicAck;
import com.common.bean.ContactBean;
import com.common.bean.ContactInfoBean;
import com.common.bean.CouponBean;
import com.common.bean.DisplayBean;
import com.common.bean.EmploymentServerBean;
import com.common.bean.GatewayInfoBean;
import com.common.bean.InviteeBean;
import com.common.bean.InviteePersonBean;
import com.common.bean.LoaningAmoutBean;
import com.common.bean.MsgInboxBean;
import com.common.bean.PersonalInfoServerBean;
import com.common.bean.PhotoListBean;
import com.common.bean.RecordFilesResponse;
import com.common.bean.RegionBean;
import com.common.bean.SysDictBean;
import com.common.bean.ThirdPartDataBean;
import com.common.bean.ThirdPartItemBean;
import com.common.bean.ThirdPartListBean;
import com.common.bean.TokenInfoBean;
import com.common.bean.UserBankInfo;
import com.common.bean.UserBean;
import com.common.bean.YWUser;

/**
 * Created by SiKang on 2018/9/14.
 * 和用户相关的API
 */
public interface UserApi {

    /**
     * 发送验证码
     */
    @FormUrlEncoded
    @POST("auth/login/sms")
    Observable<BasicAck> sendSms(@Field("mobile") String mobile);

    /**
     * 登录
     */
    @FormUrlEncoded
    @POST("auth/login")
    Observable<TokenInfoBean> login(@Header("X-SMS-CODE") String smsCode,
                                    @Header("X-CAPTCHA-SID") String captchaSid,
                                    @Header("X-CAPTCHA") String captcha,
                                    @Field("mobile") String mobile,
                                    @Field("code") String code);

    /**
     * facebook accountKit登录
     */
    @FormUrlEncoded
    @POST("auth/login_account_kit")
    Observable<TokenInfoBean> accountKitLogin(@Field("mobile") String mobile, @Field("auth_code") String auth_code);


    /**
     * 获取身份证照片
     */
    @GET("record/ktp-photo")
    Observable<RecordFilesResponse> getKtpImg();


    /**
     * 上传firebase 推送图片
     */
    @FormUrlEncoded
    @PUT("record/firebase_token")
    Observable<ResponseBody> uploadFirebaseToken(@Field("firebase_token") String token);


    /**
     * 获取认证信息
     */
    @GET("record/personalinfo")
    Observable<PersonalInfoServerBean> getPersonalInfo();

    /**
     * 用户信息
     */
    @GET("info/infocenter")
    Observable<UserBean> getUserInfo();

    /**
     * 埋点
     */
    @GET("loanapp/point_report")
    Observable<ResponseBody> trackEvent(@Query("reportType") String reportType,
                                      @Query("actionType") String actionType,
                                      @Query("comment") String comment
    );


    /**
     * 学历列表
     */
    @GET("sysdict/{type}")
    Observable<ArrayList<SysDictBean>> sysDict(@Path("type") String type);


    /**
     * 区域列表
     */
    @GET("region/{level}/{id}")
    Observable<RegionBean> getRegion(@Path("level") String level,
                                     @Path("id") int id
    );

    /**
     * 获取最新 Gateway 信息
     */
    @GET
    Observable<GatewayInfoBean> getGateway(@Url String url);


    /**
     * 提交联系人信息
     */
    @FormUrlEncoded
    @PUT("record/contact")
    Observable<ResponseBody> submitContactInfo(@Field("parentId") String parentId,
                                               @Field("parentName") String parentName,
                                               @Field("parentMobile") String parentMobile,
                                               @Field("parentType") String parentType,
                                               @Field("friendId") String friendId,
                                               @Field("friendName") String friendName,
                                               @Field("friendMobile") String friendMobile,
                                               @Field("friendType") String friendType,
                                               @Field("friendId1") String friendId1,
                                               @Field("friendName1") String friendName1,
                                               @Field("friendMobile1") String friendMobile1,
                                               @Field("friendType1") String friendType1);


    @GET("/record/emergency/contact/list")
    Observable<List<ContactBean>> getContactList();

    @Headers("Content-Type: application/json")
    @PUT("/record/emergency/contact")
    Observable<BasicAck> submitContactList(@Body List<ContactBean> contactList);


    /**
     * 提交工作认证信息
     */
    @FormUrlEncoded
    @PUT("record/employment")
    Observable<ResponseBody> submitEmploymentInfo(@Field("companyName") String companyName,
                                                  @Field("companyProvince") String companyProvince,
                                                  @Field("companyCity") String companyCity,
                                                  @Field("companyDistrict") String companyDistrict,
                                                  @Field("companyArea") String companyArea,
                                                  @Field("companyAddress") String companyAddress,
                                                  @Field("companyPhone") String companyPhone,
                                                  @Field("profession") String profession,
                                                  @Field("salary") String salary);


    /**
     * 提交个人信息
     */
    @FormUrlEncoded
    @PUT("record/personalinfo")
    Observable<ResponseBody> submitPersonalInfo(@Field("fullName") String fullName,
                                                @Field("credentialNo") String credentialNo,
                                                @Field("familyNameInLaw") String familyNameInLaw,
                                                @Field("gender") String gender,
                                                @Field("province") String province,
                                                @Field("city") String city,
                                                @Field("district") String district,
                                                @Field("area") String area,
                                                @Field("address") String address,
                                                @Field("lastEducation") String lastEducation,
                                                @Field("maritalStatus") String maritalStatus,
                                                @Field("childrenNumber") String childrenNumber,
                                                @Field("residenceDuration") String residenceDuration,
                                                @Field("facebookId") String facebookId,
                                                @Field("whatsappId") String whatsappId);


    /**
     * 退出登录
     */
    @FormUrlEncoded
    @POST("auth/logout")
    Observable<ResponseBody> logout(@Field("token") String token);


    /**
     * 消息列表
     */
    @GET("info/inbox/all")
    Observable<List<MsgInboxBean>> getMsgInbox();


    /**
     * 已读消息列表
     */
    @FormUrlEncoded
    @POST("info/inbox/read")
    Observable<ResponseBody> sendReadMsg(@Field("msgId") String msgId);


    /**
     * 获取联系人信息
     */
    @GET("record/contact")
    Observable<ContactInfoBean> getContactInfo();

    /**
     * 获取工作认证信息
     */
    @GET("record/employment")
    Observable<EmploymentServerBean> getEmploymentInfo();


    /**
     * 最新版本号
     */
    @GET("version/latest")
    Observable<ResponseBody> getVersionInfo();


    /**
     * 获取活动Bannder信息
     */
    @GET("banner")
    Observable<List<ActivityInfoBean>> getActivityList();

    /**
     * 贷款详情
     */
    @GET("loanapp/repayment-amount-detail")
    Observable<LoaningAmoutBean> getLoanAmoutData(@Query("principal") double amount,
                                                  @Query("period") int day,
                                                  @Query("periodUnit") String periodUnit,
                                                  @Query("productId") long productId);

    /**
     * 客户服务热线、公司介绍
     */
    @GET("loanapp/display")
    Observable<DisplayBean> display();


    @GET("record/employ-photo")
    Observable<RecordFilesResponse> getJobImg();


    @GET("record/bankcard")
    Observable<UserBankInfo> getBankCardInfo();


    /**
     * 绑定的第三方账号
     */
    @GET("record/thirdparty_data")
    Observable<ThirdPartDataBean> getThirdPartAccount();

    /**
     * 同盾列表
     */
    @GET("record/thirdparty_data_list")
    Observable<List<ThirdPartItemBean>> getThirdPartList();



    /**
     * 同盾列表V2
     */
    @GET("record/thirdparty_data_list/v2")
    Observable<ThirdPartListBean> getThirdPartListV2();

    /**
     * 公告
     */
    @GET("banner/message")
    Observable<List<BannerMessageDto>> getBannerMsg();

    /**
     * 获取其他证明图片列表
     */
    @GET("/record/files-extra")
    Observable<PhotoListBean> getPhotoList();


    /**
     * 提交第三方数据
     */
    @PUT("record/thirdparty_data")
    Observable<ResponseBody> submitThirdPartData(@Query("dataChannel") String dataChannel,
                                                 @Query("dataType") String dataType,
                                                 @Query("taskId") String taskId,
                                                 @Query("credentialNo") String credentialNo,
                                                 @Query("realName") String realName,
                                                 @Query("mobile") String mobile,
                                                 @Query("passbackparams") String passbackparams);


}
