package tech.starwin.utils.context_utils;

import android.Manifest;
import android.annotation.SuppressLint;
import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.provider.Settings;
import android.support.v4.app.ActivityCompat;
import android.telephony.TelephonyManager;
import android.text.TextUtils;

import java.util.UUID;

import tech.starwin.utils.PreferencesManager;

/**
 * Created by SiKang on 2018/12/10.
 */
public class AppInfoUtils {

    /**
     * 获取应用程序名称
     */
    public static synchronized String getAppName(Context context) {
        try {
            PackageManager packageManager = context.getPackageManager();
            PackageInfo packageInfo = packageManager.getPackageInfo(context.getPackageName(), 0);
            int labelRes = packageInfo.applicationInfo.labelRes;
            return context.getResources().getString(labelRes);
        } catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    /**
     * 获取AndroidID
     */
    public static String getAndroidID(Context context) {
        String android_id = Settings.Secure.getString(context.getContentResolver(), Settings.Secure.ANDROID_ID);
        if (TextUtils.isEmpty(android_id)) {
            android_id = PreferencesManager.get().getDeviceUUID();
            if (TextUtils.isEmpty(android_id)) {
                android_id = UUID.randomUUID().toString();
                PreferencesManager.get().saveDeviceUUID(android_id);
            }
        }
        return android_id;
    }


    /**
     * 判断是否存在某个包且可获取入口
     */
    public static boolean isPackageExist(Context context, String packageName) {
        if (packageName == null || TextUtils.isEmpty(packageName)) {
            return false;
        }
        if (context != null) {
            try {
                if (!(TextUtils.isEmpty(packageName) || context.getPackageManager().getLaunchIntentForPackage(packageName) == null)) {
                    return true;
                }
            } catch (Exception unused) {
                return false;
            }
        }
        return false;
    }


    @SuppressLint("MissingPermission")
    public static String getPhoneNumber(Context context) {
        TelephonyManager telephonyManager = (TelephonyManager) context.getSystemService(Context.TELEPHONY_SERVICE);
        String[] permissions = new String[]{Manifest.permission.READ_SMS, Manifest.permission.READ_PHONE_STATE};
        if (telephonyManager != null && PermissionsHelper.isGranted(context, permissions)) {
            return telephonyManager.getLine1Number();
        } else {
            return "";
        }

    }


}
