# -*-coding:utf-8-*-
import os


class Shell:
    #commit&push project
    @staticmethod
    def push_project(config):
        command = "%s\n%s\n%s\n%s\n" \
            % (
                "cd "+config['root'],
                "git add .",
                "git commit -m \"%s\"" % (config['app_id'] +" " + config['version_name']),
                "git push origin %s" % config['git_branch']
            )
        os.system(command)

    #commit&push lib_base
    @staticmethod
    def push_base(config):
        commit_msg = input("输入commit msg: ")
        command = "%s\n%s\n%s\n%s\n" \
            % (
                "cd %s/%s" % (config['root'],"lib_base"),
                "git add .",
                "git commit -m \"%s\"" % commit_msg,
                "git push origin master"
            )
        os.system(command)

    #pull lib_base & cash_plugin_toolbox
    @staticmethod
    def pull_base(config):
        command = "%s\n%s\n%s\n%s\n%s\n%s\n%s\n%s\n%s\n%s\n%s\n" \
            % (
                "cd %s" % config['root'],
                "git submodule update --remote",
                "cd lib_base",
                "git checkout master",
                "git pull",
                "cd ../cash_plugin_toolbox",
                "git checkout master",
                "git pull",
                "cd ../lib_yitu || { echo \"lib_yitu not exist\"; exit 1; }",
                "git checkout master",
                "git pull"
            )
        os.system(command)

    #push with tag
    @staticmethod
    def push_with_tag(config):
        Shell.push_project(config)
        tagName="t%s-%s" % (config['corp_id'],config['app_id'])
        command = "%s\n%s\n%s\n%s\n%s\n" \
            % (
                "cd %s" % config['root'],
                "git tag -d %s" % tagName,
                "git push origin --delete tag %s" % tagName,
                "git tag -a %s -m %s" % (tagName,tagName),
                "git push origin %s" % tagName,
            )
        os.system(command)
