package com.common.activity;

import android.content.Context;
import android.support.v7.widget.RecyclerView;

import java.util.ArrayList;
import java.util.List;

import tech.starwin.LibConfig;
import tech.starwin.R;

import com.common.base.BaseActivity;
import com.common.bean.LoanAppHelpCenterTipsBean;

import tech.starwin.mvp.ui.adapter.HelpCenterAdapter;
import tech.starwin.utils.context_utils.ActivityJumper;
import tech.starwin.utils.ui_utils.UIHelper;

/**
 * Created by SiKang on 2018/11/1.
 */
public class HelpCenterActivity extends BaseActivity {

    @Deprecated
    public static void start(Context context, String[] questionTips) {
        new ActivityJumper.Builder(context, HelpCenterActivity.class)
                .put("questionTips", questionTips)
                .build().start();
    }

    public static void start(Context context) {
        new ActivityJumper.Builder(context, HelpCenterActivity.class).build().start();
    }


    @Override
    public int bindLayout() {
        return R.layout.activity_help_center;
    }


    @Override
    public void initView() {
        setTopBarTitle(getString(R.string.text_me_help_center));
        RecyclerView mHelpRv = findViewById(R.id.activity_helpCenter_rv);
        UIHelper.bindAdapter(mHelpRv, new HelpCenterAdapter(this, getHelpData()));
    }


    private List<LoanAppHelpCenterTipsBean> getHelpData() {
        List<LoanAppHelpCenterTipsBean> data = new ArrayList<>();
        String[] questions = getResources().getStringArray(R.array.text_helpcenter_questions);
//        String[] tips = (String[]) getIntent().getSerializableExtra("questionTips");
        String[] tips = getResources().getStringArray(R.array.text_helpcenter_questions_tips);

        String appName = LibConfig.APP_NAME.replace(" ", "-");
        for (int i = 0; i < questions.length; i++) {
            LoanAppHelpCenterTipsBean bean = new LoanAppHelpCenterTipsBean();
            bean.mTitle = questions[i];
            bean.mDetail = String.format(tips[i], appName, appName);
            data.add(bean);
        }
        return data;
    }

    @Override
    public void onHttpSuccess(String action, Object result) {

    }
}
