/*
 * Decompiled with CFR 0.152.
 */
package com.meituan.android.walle.commands;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.beust.jcommander.converters.FileConverter;
import com.meituan.android.walle.ChannelWriter;
import com.meituan.android.walle.SignatureNotFoundException;
import com.meituan.android.walle.commands.IWalleCommand;
import com.meituan.android.walle.utils.CommaSeparatedKeyValueConverter;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;

@Parameters(commandDescription="put channel info into apk")
public class PutCommand
implements IWalleCommand {
    @Parameter(required=true, description="inputFile [outputFile]", arity=2, converter=FileConverter.class)
    private List<File> files;
    @Parameter(names={"-e", "--extraInfo"}, converter=CommaSeparatedKeyValueConverter.class, description="Comma-separated list of key=value info, eg: -e time=1,type=android")
    private Map<String, String> extraInfo;
    @Parameter(names={"-c", "--channel"}, description="single channel, eg: -c meituan")
    private String channel;

    @Override
    public void parse() {
        File inputFile = this.files.get(0);
        File outputFile = null;
        if (this.files.size() == 2) {
            outputFile = this.files.get(1);
        } else {
            String name = FilenameUtils.getBaseName(inputFile.getName());
            String extension = FilenameUtils.getExtension(inputFile.getName());
            String newName = name + "_" + this.channel + "." + extension;
            outputFile = new File(inputFile.getParent(), newName);
        }
        if (inputFile.equals(outputFile)) {
            try {
                ChannelWriter.put(outputFile, this.channel, this.extraInfo);
            }
            catch (SignatureNotFoundException | IOException e) {
                e.printStackTrace();
            }
        } else {
            try {
                FileUtils.copyFile(inputFile, outputFile);
                ChannelWriter.put(outputFile, this.channel, this.extraInfo);
            }
            catch (SignatureNotFoundException | IOException e) {
                e.printStackTrace();
            }
        }
    }
}

